/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.File;
import java.util.ArrayList;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.leveldb.LevelDBStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ6121Test {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ6121Test.class);
    private BrokerService broker;

    @Before
    public void startBroker() throws Exception {
        this.broker = new BrokerService();
        LevelDBStore levelDBStore = new LevelDBStore();
        File directory = new File("target/activemq-data/myleveldb");
        IOHelper.deleteChildren((File)directory);
        levelDBStore.setDirectory(directory);
        levelDBStore.deleteAllMessages();
        PolicyMap policyMap = new PolicyMap();
        ArrayList<PolicyEntry> entries = new ArrayList<PolicyEntry>();
        PolicyEntry pe = new PolicyEntry();
        pe.setExpireMessagesPeriod(8000L);
        pe.setMaxAuditDepth(25);
        pe.setUseCache(false);
        pe.setLazyDispatch(false);
        pe.setOptimizedDispatch(true);
        pe.setProducerFlowControl(false);
        pe.setEnableAudit(true);
        pe.setQueue(">");
        entries.add(pe);
        policyMap.setPolicyEntries(entries);
        this.broker.setDestinationPolicy(policyMap);
        this.broker.setPersistenceAdapter((PersistenceAdapter)levelDBStore);
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    @After
    public void stopBroker() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    @Test(timeout=30000L)
    public void sendToDLQ() throws Exception {
        int MSG_COUNT = 50;
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.broker.getVmConnectorURI());
        Connection connection = connectionFactory.createConnection();
        Session session = connection.createSession(false, 1);
        Queue destination = session.createQueue("ActiveMQ.DLQ");
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.setDeliveryMode(2);
        TextMessage txtMessage = session.createTextMessage();
        txtMessage.setText("Test_Message");
        for (int i = 0; i < 50; ++i) {
            producer.send((Message)txtMessage, 2, 4, 1000L);
        }
        final QueueViewMBean view = this.getProxyToQueue("ActiveMQ.DLQ");
        LOG.info("WAITING for expiry...");
        Assert.assertTrue((String)"Queue drained of expired", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return view.getQueueSize() == 0L;
            }
        }));
        LOG.info("FINISHED WAITING for expiry.");
        LOG.info("Queue enqueue counter ==>>>" + view.getEnqueueCount());
        Assert.assertEquals((String)"Enqueue size ", (long)50L, (long)view.getEnqueueCount());
        connection.close();
    }

    protected QueueViewMBean getProxyToQueue(String name) throws MalformedObjectNameException, JMSException {
        ObjectName queueViewMBeanName = new ObjectName("org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + name);
        QueueViewMBean proxy = (QueueViewMBean)this.broker.getManagementContext().newProxyInstance(queueViewMBeanName, QueueViewMBean.class, true);
        return proxy;
    }
}

