/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.File;
import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.RedeliveryPolicyMap;
import org.apache.activemq.broker.scheduler.Job;
import org.apache.activemq.broker.scheduler.JobScheduler;
import org.apache.activemq.broker.scheduler.JobSchedulerStore;
import org.apache.activemq.broker.util.RedeliveryPlugin;
import org.apache.activemq.store.kahadb.scheduler.JobSchedulerStoreImpl;
import org.apache.activemq.util.IOHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ7002Test {
    static final Logger LOG = LoggerFactory.getLogger(AMQ7002Test.class);
    protected ActiveMQConnection connection;
    protected ActiveMQConnectionFactory connectionFactory;
    private BrokerService brokerService;
    private JobSchedulerStoreImpl store;

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
    }

    protected Connection createConnection() throws Exception {
        return this.getConnectionFactory().createConnection();
    }

    public ActiveMQConnectionFactory getConnectionFactory() throws Exception {
        if (this.connectionFactory == null) {
            this.connectionFactory = this.createConnectionFactory();
            Assert.assertTrue((String)"Should have created a connection factory!", (this.connectionFactory != null ? 1 : 0) != 0);
        }
        return this.connectionFactory;
    }

    protected BrokerService createBroker() throws Exception {
        File directory = new File("target/test/ScheduledJobsDB");
        IOHelper.mkdirs((File)directory);
        IOHelper.deleteChildren((File)directory);
        this.createSchedulerStore(directory);
        BrokerService service = new BrokerService();
        service.setPersistent(true);
        service.setUseJmx(false);
        service.setJobSchedulerStore((JobSchedulerStore)this.store);
        service.setSchedulerSupport(true);
        service.setDeleteAllMessagesOnStartup(true);
        RedeliveryPlugin redeliveryPlugin = new RedeliveryPlugin();
        RedeliveryPolicy brokerRedeliveryPolicy = new RedeliveryPolicy();
        brokerRedeliveryPolicy.setInitialRedeliveryDelay(60000L);
        brokerRedeliveryPolicy.setMaximumRedeliveries(20);
        brokerRedeliveryPolicy.setMaximumRedeliveryDelay(300000L);
        brokerRedeliveryPolicy.setBackOffMultiplier(2.0);
        RedeliveryPolicyMap redeliveryPolicyMap = new RedeliveryPolicyMap();
        redeliveryPolicyMap.setDefaultEntry(brokerRedeliveryPolicy);
        redeliveryPlugin.setRedeliveryPolicyMap(redeliveryPolicyMap);
        service.setPlugins(new BrokerPlugin[]{redeliveryPlugin});
        service.start();
        service.waitUntilStarted();
        return service;
    }

    protected ConsumerObject getConsumer(int id) throws Exception {
        RedeliveryPolicy redeliveryPolicy = new RedeliveryPolicy();
        redeliveryPolicy.setInitialRedeliveryDelay(0L);
        redeliveryPolicy.setMaximumRedeliveries(0);
        ActiveMQConnection consumerConnection = (ActiveMQConnection)this.createConnection();
        consumerConnection.setRedeliveryPolicy(redeliveryPolicy);
        consumerConnection.start();
        Session consumerSession = consumerConnection.createSession(true, 0);
        MessageConsumer consumer = consumerSession.createConsumer((Destination)consumerSession.createQueue("Consumer." + id + ".VirtualTopic.Orders"));
        LOG.info(consumer.toString());
        ConsumerObject co = new ConsumerObject(consumerSession, consumer, (Connection)consumerConnection);
        return co;
    }

    @Before
    public void before() throws Exception {
        this.brokerService = this.createBroker();
    }

    @After
    public void after() throws Exception {
        this.brokerService.stop();
        this.brokerService.waitUntilStopped();
    }

    @Test
    public void TestDuplicateJobIDs() throws Exception {
        ConsumerObject consumer1 = this.getConsumer(1);
        ConsumerObject consumer2 = this.getConsumer(2);
        ActiveMQConnection producerConnection = (ActiveMQConnection)this.createConnection();
        producerConnection.start();
        Session session = producerConnection.createSession(false, 2);
        Topic dest = session.createTopic("VirtualTopic.Orders");
        MessageProducer producer = session.createProducer((Destination)dest);
        TextMessage msg = session.createTextMessage("Test Me");
        producer.setDeliveryMode(1);
        producer.send((Message)msg);
        Message message1 = consumer1.getConsumer().receive();
        TestCase.assertNotNull((String)"got message", (Object)message1);
        LOG.info("got: " + message1);
        Message message2 = consumer2.getConsumer().receive();
        TestCase.assertNotNull((String)"got message", (Object)message2);
        LOG.info("got: " + message2);
        consumer1.getSession().rollback();
        consumer2.getSession().rollback();
        Thread.sleep(2000L);
        JobScheduler js = this.brokerService.getJobSchedulerStore().getJobScheduler("JMS");
        List jobList = js.getAllJobs();
        TestCase.assertNotNull((Object)jobList);
        Assert.assertEquals((long)2L, (long)jobList.size());
        String jobId1 = ((Job)jobList.get(0)).getJobId();
        String jobId2 = ((Job)jobList.get(1)).getJobId();
        Assert.assertFalse((String)"FAIL: JobIDs are duplicates!", (boolean)jobId1.equals(jobId2));
    }

    protected void createSchedulerStore(File directory) throws Exception {
        this.store = new JobSchedulerStoreImpl();
        this.store.setDirectory(directory);
        this.store.setCheckpointInterval(5000L);
        this.store.setCleanupInterval(10000L);
    }

    private class ConsumerObject {
        Session session;
        MessageConsumer consumer;
        Connection connection;

        public ConsumerObject(Session session, MessageConsumer consumer, Connection connection) {
            this.session = session;
            this.consumer = consumer;
            this.connection = connection;
        }

        public Session getSession() {
            return this.session;
        }

        public void setSession(Session session) {
            this.session = session;
        }

        public MessageConsumer getConsumer() {
            return this.consumer;
        }

        public void setConsumer(MessageConsumer consumer) {
            this.consumer = consumer;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public void setConnection(Connection connection) {
            this.connection = connection;
        }
    }
}

