/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerFilter;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConsumerBrokerExchange;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.DestinationView;
import org.apache.activemq.broker.jmx.QueueView;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MessageExpiryTimeDifferenceTest {
    public static final String QUEUE_NAME = "timeout.test";
    private ActiveMQConnection connection;
    private BrokerService broker;
    private String connectionUri;

    @Before
    public void setUp() throws Exception {
        this.createBroker();
        this.connection = this.createConnection();
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    @Test(timeout=30000L)
    public void testInflightCountAfterExpiry() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        Queue queue = session.createQueue(QUEUE_NAME);
        MessageProducer producer = session.createProducer((Destination)queue);
        TextMessage textMessage = session.createTextMessage(QUEUE_NAME);
        producer.send((javax.jms.Message)textMessage);
        session.close();
        session = this.connection.createSession(false, 1);
        final MessageConsumer consumer = session.createConsumer((Destination)queue);
        final CountDownLatch messageReceived = new CountDownLatch(1);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                javax.jms.Message message = null;
                try {
                    message = consumer.receive(1000L);
                }
                catch (JMSException e) {
                    Assert.fail();
                }
                Assert.assertNull((Object)message);
                messageReceived.countDown();
            }
        });
        messageReceived.await(20L, TimeUnit.SECONDS);
        QueueView queueView = this.getQueueView(this.broker, QUEUE_NAME);
        Assert.assertEquals((String)"Should be No inflight messages", (long)0L, (long)queueView.getInFlightCount());
    }

    private void createBroker() throws Exception {
        this.broker = new BrokerService();
        this.broker.setUseJmx(true);
        this.broker.setPersistent(false);
        this.broker.setAdvisorySupport(false);
        this.broker.addConnector("tcp://localhost:0");
        this.broker.setPlugins(new BrokerPlugin[]{new BrokerPlugin(){

            public Broker installPlugin(Broker broker) throws Exception {
                return new BrokerFilter(broker){
                    private AtomicInteger counter;
                    private Message dispatchedMessage;
                    {
                        this.counter = new AtomicInteger();
                    }

                    public void preProcessDispatch(MessageDispatch messageDispatch) {
                        if (this.counter.get() == 0 && messageDispatch.getDestination().getPhysicalName().contains(MessageExpiryTimeDifferenceTest.QUEUE_NAME)) {
                            this.dispatchedMessage = messageDispatch.getMessage();
                            this.dispatchedMessage.setExpiration(System.currentTimeMillis() - 100L);
                            this.counter.incrementAndGet();
                        }
                        super.preProcessDispatch(messageDispatch);
                    }

                    public void acknowledge(ConsumerBrokerExchange consumerExchange, MessageAck ack) throws Exception {
                        if (ack.isExpiredAck()) {
                            this.dispatchedMessage.setExpiration(System.currentTimeMillis() + 300000L);
                        }
                        super.acknowledge(consumerExchange, ack);
                    }
                };
            }
        }});
        this.broker.start();
        this.broker.waitUntilStarted();
        this.connectionUri = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString();
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.connectionUri);
    }

    protected ActiveMQConnection createConnection() throws Exception {
        return (ActiveMQConnection)this.createConnectionFactory().createConnection();
    }

    private QueueView getQueueView(BrokerService broker, String queueName) throws Exception {
        Map queueViews = broker.getAdminView().getBroker().getQueueViews();
        for (ObjectName key : queueViews.keySet()) {
            QueueView queueView;
            DestinationView destinationView = (DestinationView)queueViews.get(key);
            if (!(destinationView instanceof QueueView) || !(queueView = (QueueView)destinationView).getName().equals(queueName)) continue;
            return queueView;
        }
        return null;
    }
}

