/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueConnection;
import javax.jms.QueueRequestor;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.console.CommandContext;
import org.apache.activemq.console.command.PurgeCommand;
import org.apache.activemq.console.formatter.CommandShellOutputFormatter;
import org.apache.activemq.console.formatter.OutputFormatter;
import org.apache.activemq.console.util.JmxMBeansUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class PurgeCommandTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(PurgeCommandTest.class);
    protected static final int MESSAGE_COUNT = 10;
    protected static final String PROPERTY_NAME = "XTestProperty";
    protected static final String PROPERTY_VALUE = "1:1";
    protected static final String MSG_SEL_WITH_PROPERTY = "XTestProperty is not null";
    protected static final String MSG_SEL_WITHOUT_PROPERTY = "XTestProperty is null";
    protected static final String MSG_SEL_COMPLEX = "XTestProperty='1:1' AND JMSPriority>3";
    protected static final String MSG_SEL_COMPLEX_SQL_AND = "(XTestProperty='1:1') AND (JMSPriority>3)";
    protected static final String MSG_SEL_COMPLEX_SQL_OR = "(XTestProperty='1:1') OR (JMSPriority>3)";
    protected static final String QUEUE_NAME = "org.apache.activemq.network.jms.QueueBridgeTest";
    protected AbstractApplicationContext context;
    protected QueueConnection localConnection;
    protected QueueRequestor requestor;
    protected QueueSession requestServerSession;
    protected MessageConsumer requestServerConsumer;
    protected MessageProducer requestServerProducer;
    protected Queue theQueue;

    protected void setUp() throws Exception {
        super.setUp();
        this.context = this.createApplicationContext();
        this.createConnections();
        this.requestServerSession = this.localConnection.createQueueSession(false, 1);
        this.theQueue = this.requestServerSession.createQueue(QUEUE_NAME);
        this.requestServerConsumer = this.requestServerSession.createConsumer((Destination)this.theQueue);
        this.requestServerProducer = this.requestServerSession.createProducer(null);
        QueueSession session = this.localConnection.createQueueSession(false, 1);
        this.requestor = new QueueRequestor(session, this.theQueue);
    }

    protected void createConnections() throws JMSException {
        ActiveMQConnectionFactory fac = (ActiveMQConnectionFactory)this.context.getBean("localFactory");
        this.localConnection = fac.createQueueConnection();
        this.localConnection.start();
    }

    protected AbstractApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/activemq/console/command/activemq.xml");
    }

    protected void tearDown() throws Exception {
        this.localConnection.close();
        BrokerService broker = (BrokerService)this.context.getBean("localbroker");
        broker.stop();
        broker = (BrokerService)this.context.getBean("default");
        broker.stop();
        super.tearDown();
    }

    public int getMessageCount(QueueBrowser browser, String prefix) throws JMSException {
        Enumeration e = browser.getEnumeration();
        int with = 0;
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            System.out.println(prefix + o);
            ++with;
        }
        return with;
    }

    public void cleanup() throws JMSException {
        for (int i = 0; i < 20; ++i) {
            this.requestServerConsumer.receive();
        }
    }

    protected MBeanServerConnection createJmxConnection() throws IOException {
        return ManagementFactory.getPlatformMBeanServer();
    }

    public void purgeAllMessages() throws IOException, Exception {
        List queueList = JmxMBeansUtil.queryMBeans((MBeanServerConnection)this.createJmxConnection(), (String)"type=Broker,brokerName=localbroker,destinationType=Queue,destinationName=*");
        for (ObjectInstance oi : queueList) {
            ObjectName queueName = oi.getObjectName();
            LOG.info("Purging all messages in queue: " + queueName.getKeyProperty("Destination"));
            this.createJmxConnection().invoke(queueName, "purge", new Object[0], new String[0]);
        }
    }

    public void addMessages() throws IOException, Exception {
        TextMessage msg;
        int i;
        this.purgeAllMessages();
        for (i = 0; i < 10; ++i) {
            msg = this.requestServerSession.createTextMessage("test msg: " + i);
            msg.setStringProperty(PROPERTY_NAME, PROPERTY_VALUE);
            this.requestServerProducer.send((Destination)this.theQueue, (Message)msg);
        }
        for (i = 0; i < 10; ++i) {
            msg = this.requestServerSession.createTextMessage("test msg: " + i);
            this.requestServerProducer.send((Destination)this.theQueue, (Message)msg);
        }
    }

    public void validateCounts(int expectedWithCount, int expectedWithoutCount, int expectedAllCount) throws JMSException {
        QueueBrowser withPropertyBrowser = this.requestServerSession.createBrowser(this.theQueue, MSG_SEL_WITH_PROPERTY);
        QueueBrowser withoutPropertyBrowser = this.requestServerSession.createBrowser(this.theQueue, MSG_SEL_WITHOUT_PROPERTY);
        QueueBrowser allBrowser = this.requestServerSession.createBrowser(this.theQueue);
        int withCount = this.getMessageCount(withPropertyBrowser, "withProperty ");
        int withoutCount = this.getMessageCount(withoutPropertyBrowser, "withoutProperty ");
        int allCount = this.getMessageCount(allBrowser, "allMessages ");
        withPropertyBrowser.close();
        withoutPropertyBrowser.close();
        allBrowser.close();
        PurgeCommandTest.assertEquals((String)("Expected withCount to be " + expectedWithCount + " was " + withCount), (int)expectedWithCount, (int)withCount);
        PurgeCommandTest.assertEquals((String)("Expected withoutCount to be " + expectedWithoutCount + " was " + withoutCount), (int)expectedWithoutCount, (int)withoutCount);
        PurgeCommandTest.assertEquals((String)("Expected allCount to be " + expectedAllCount + " was " + allCount), (int)expectedAllCount, (int)allCount);
        LOG.info("withCount = " + withCount + "\n withoutCount = " + withoutCount + "\n allCount = " + allCount + "\n  = \n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueueViewMbean() throws Exception {
        try {
            this.addMessages();
            this.validateCounts(10, 10, 20);
            List<String> tokens = Arrays.asList("*");
            for (String token : tokens) {
                List queueList = JmxMBeansUtil.queryMBeans((MBeanServerConnection)this.createJmxConnection(), (String)("type=Broker,brokerName=localbroker,destinationType=Queue,destinationName=" + token));
                for (ObjectInstance queue : queueList) {
                    ObjectName queueName = queue.getObjectName();
                    QueueViewMBean proxy = MBeanServerInvocationHandler.newProxyInstance(this.createJmxConnection(), queueName, QueueViewMBean.class, true);
                    int removed = proxy.removeMatchingMessages(MSG_SEL_WITH_PROPERTY);
                    LOG.info("Removed: " + removed);
                }
            }
            this.validateCounts(0, 10, 10);
        }
        finally {
            this.purgeAllMessages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPurgeCommandSimpleSelector() throws Exception {
        try {
            PurgeCommand purgeCommand = new PurgeCommand();
            CommandContext context = new CommandContext();
            context.setFormatter((OutputFormatter)new CommandShellOutputFormatter((OutputStream)System.out));
            purgeCommand.setCommandContext(context);
            purgeCommand.setJmxUseLocal(true);
            ArrayList<String> tokens = new ArrayList<String>();
            tokens.add("--msgsel");
            tokens.add(MSG_SEL_WITH_PROPERTY);
            this.addMessages();
            this.validateCounts(10, 10, 20);
            purgeCommand.execute(tokens);
            this.validateCounts(0, 10, 10);
        }
        finally {
            this.purgeAllMessages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPurgeCommandComplexSelector() throws Exception {
        try {
            PurgeCommand purgeCommand = new PurgeCommand();
            CommandContext context = new CommandContext();
            context.setFormatter((OutputFormatter)new CommandShellOutputFormatter((OutputStream)System.out));
            purgeCommand.setCommandContext(context);
            purgeCommand.setJmxUseLocal(true);
            ArrayList<String> tokens = new ArrayList<String>();
            tokens.add("--msgsel");
            tokens.add(MSG_SEL_COMPLEX);
            this.addMessages();
            this.validateCounts(10, 10, 20);
            purgeCommand.execute(tokens);
            QueueBrowser withPropertyBrowser = this.requestServerSession.createBrowser(this.theQueue, MSG_SEL_COMPLEX);
            QueueBrowser allBrowser = this.requestServerSession.createBrowser(this.theQueue);
            int withCount = this.getMessageCount(withPropertyBrowser, "withProperty ");
            int allCount = this.getMessageCount(allBrowser, "allMessages ");
            withPropertyBrowser.close();
            allBrowser.close();
            PurgeCommandTest.assertEquals((String)("Expected withCount to be 0 was " + withCount), (int)0, (int)withCount);
            PurgeCommandTest.assertEquals((String)("Expected allCount to be 10 was " + allCount), (int)10, (int)allCount);
            LOG.info("withCount = " + withCount + "\n allCount = " + allCount + "\n  = \n");
        }
        finally {
            this.purgeAllMessages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPurgeCommandComplexSQLSelector_AND() throws Exception {
        try {
            String one = "ID:mac.fritz.box:1213242.3231.1:1:1:100";
            String two = "\\*:100";
            try {
                if (one.matches(two)) {
                    LOG.info("String matches.");
                } else {
                    LOG.info("string does not match.");
                }
            }
            catch (Exception ex) {
                LOG.error(ex.getMessage());
            }
            PurgeCommand purgeCommand = new PurgeCommand();
            CommandContext context = new CommandContext();
            context.setFormatter((OutputFormatter)new CommandShellOutputFormatter((OutputStream)System.out));
            purgeCommand.setCommandContext(context);
            purgeCommand.setJmxUseLocal(true);
            ArrayList<String> tokens = new ArrayList<String>();
            tokens.add("--msgsel");
            tokens.add(MSG_SEL_COMPLEX_SQL_AND);
            this.addMessages();
            this.validateCounts(10, 10, 20);
            purgeCommand.execute(tokens);
            QueueBrowser withPropertyBrowser = this.requestServerSession.createBrowser(this.theQueue, MSG_SEL_COMPLEX_SQL_AND);
            QueueBrowser allBrowser = this.requestServerSession.createBrowser(this.theQueue);
            int withCount = this.getMessageCount(withPropertyBrowser, "withProperty ");
            int allCount = this.getMessageCount(allBrowser, "allMessages ");
            withPropertyBrowser.close();
            allBrowser.close();
            PurgeCommandTest.assertEquals((String)("Expected withCount to be 0 was " + withCount), (int)0, (int)withCount);
            PurgeCommandTest.assertEquals((String)("Expected allCount to be 10 was " + allCount), (int)10, (int)allCount);
            LOG.info("withCount = " + withCount + "\n allCount = " + allCount + "\n  = \n");
        }
        finally {
            this.purgeAllMessages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPurgeCommandComplexSQLSelector_OR() throws Exception {
        try {
            PurgeCommand purgeCommand = new PurgeCommand();
            CommandContext context = new CommandContext();
            context.setFormatter((OutputFormatter)new CommandShellOutputFormatter((OutputStream)System.out));
            purgeCommand.setCommandContext(context);
            purgeCommand.setJmxUseLocal(true);
            ArrayList<String> tokens = new ArrayList<String>();
            tokens.add("--msgsel");
            tokens.add(MSG_SEL_COMPLEX_SQL_OR);
            this.addMessages();
            this.validateCounts(10, 10, 20);
            purgeCommand.execute(tokens);
            QueueBrowser withPropertyBrowser = this.requestServerSession.createBrowser(this.theQueue, MSG_SEL_COMPLEX_SQL_OR);
            QueueBrowser allBrowser = this.requestServerSession.createBrowser(this.theQueue);
            int withCount = this.getMessageCount(withPropertyBrowser, "withProperty ");
            int allCount = this.getMessageCount(allBrowser, "allMessages ");
            withPropertyBrowser.close();
            allBrowser.close();
            PurgeCommandTest.assertEquals((String)("Expected withCount to be 0 but was " + withCount), (int)0, (int)withCount);
            PurgeCommandTest.assertEquals((String)("Expected allCount to be 0 but was " + allCount), (int)0, (int)allCount);
            LOG.info("withCount = " + withCount + "\n allCount = " + allCount + "\n  = \n");
        }
        finally {
            this.purgeAllMessages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDummy() throws Exception {
        try {
            String one = "ID:mac.fritz.box:1213242.3231.1:1:1:100";
            String two = "ID*:100";
            try {
                if (one.matches(two)) {
                    LOG.info("String matches.");
                } else {
                    LOG.info("string does not match.");
                }
            }
            catch (Exception ex) {
                LOG.error(ex.getMessage());
            }
            PurgeCommand purgeCommand = new PurgeCommand();
            CommandContext context = new CommandContext();
            context.setFormatter((OutputFormatter)new CommandShellOutputFormatter((OutputStream)System.out));
            purgeCommand.setCommandContext(context);
            purgeCommand.setJmxUseLocal(true);
            ArrayList<String> tokens = new ArrayList<String>();
            tokens.add("--msgsel");
            tokens.add("(XTestProperty LIKE '1:*') AND (JMSPriority>3)");
            this.addMessages();
            purgeCommand.execute(tokens);
        }
        finally {
            this.purgeAllMessages();
        }
    }
}

