/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.statistics;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.statistics.AbstractInflightMessageSizeTest;
import org.apache.activemq.util.Wait;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TopicSubscriptionInflightMessageSizeTest
extends AbstractInflightMessageSizeTest {
    public TopicSubscriptionInflightMessageSizeTest(int ackType, boolean optimizeAcknowledge, boolean useTopicSubscriptionInflightStats) {
        super(ackType, optimizeAcknowledge, useTopicSubscriptionInflightStats);
    }

    @Override
    protected MessageConsumer getMessageConsumer() throws JMSException {
        return this.session.createConsumer(this.dest);
    }

    @Override
    protected Subscription getSubscription() {
        return (Subscription)this.amqDestination.getConsumers().get(0);
    }

    @Override
    protected Destination getDestination() throws JMSException {
        return this.session.createTopic("testDest");
    }

    @Override
    protected ActiveMQDestination getActiveMQDestination() {
        return new ActiveMQTopic("testDest");
    }

    @Test(timeout=15000L)
    public void testInflightMessageSizeDisabled() throws Exception {
        Assume.assumeFalse((boolean)this.useTopicSubscriptionInflightStats);
        this.sendMessages(10);
        Thread.sleep(1000L);
        Assert.assertTrue((String)"Inflight message size should be 0", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return TopicSubscriptionInflightMessageSizeTest.this.getSubscription().getInFlightMessageSize() == 0L;
            }
        }));
        this.receiveMessages(10);
        Thread.sleep(1000L);
        Assert.assertTrue((String)"Inflight message size should still be 0", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return TopicSubscriptionInflightMessageSizeTest.this.getSubscription().getInFlightMessageSize() == 0L;
            }
        }));
    }
}

