/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import java.io.File;
import java.io.FilenameFilter;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.disk.journal.Journal;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KahaDBIndexLocationTest {
    private static final Logger LOG = LoggerFactory.getLogger(KahaDBIndexLocationTest.class);
    @Rule
    public TestName name = new TestName();
    private BrokerService broker;
    private final File testDataDir = new File("target/activemq-data/QueuePurgeTest");
    private final File kahaDataDir = new File(this.testDataDir, "kahadb");
    private final File kahaIndexDir = new File(this.testDataDir, "kahadb/index");

    @Before
    public void setUp() throws Exception {
        this.startBroker();
    }

    @After
    public void tearDown() throws Exception {
        this.stopBroker();
    }

    private void startBroker() throws Exception {
        this.createBroker();
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    private void stopBroker() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    private void restartBroker() throws Exception {
        this.stopBroker();
        this.createBroker();
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    private void createBroker() throws Exception {
        this.broker = new BrokerService();
        KahaDBPersistenceAdapter persistenceAdapter = new KahaDBPersistenceAdapter();
        persistenceAdapter.setDirectory(this.kahaDataDir);
        persistenceAdapter.setIndexDirectory(this.kahaIndexDir);
        persistenceAdapter.setPreallocationScope(Journal.PreallocationScope.ENTIRE_JOURNAL.name());
        this.broker.setDataDirectoryFile(this.testDataDir);
        this.broker.setUseJmx(false);
        this.broker.setAdvisorySupport(false);
        this.broker.setSchedulerSupport(false);
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
    }

    @Test
    public void testIndexDirExists() throws Exception {
        LOG.info("Index dir is configured as: {}", (Object)this.kahaIndexDir);
        Assert.assertTrue((boolean)this.kahaDataDir.exists());
        Assert.assertTrue((boolean)this.kahaIndexDir.exists());
        String[] index = this.kahaIndexDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                LOG.info("Testing filename: {}", (Object)name);
                return name.endsWith("data") || name.endsWith("redo");
            }
        });
        String[] journal = this.kahaDataDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                LOG.info("Testing filename: {}", (Object)name);
                return name.endsWith("log") || name.equals("lock");
            }
        });
        this.produceMessages();
        Assert.assertNotNull((Object)index);
        Assert.assertEquals((long)2L, (long)index.length);
        Assert.assertNotNull((Object)journal);
        Assert.assertEquals((long)2L, (long)journal.length);
    }

    @Test
    public void testRestartWithDeleteWorksWhenIndexIsSeparate() throws Exception {
        this.produceMessages();
        this.restartBroker();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost?create=false");
        Connection connection = cf.createConnection();
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue(this.name.getMethodName());
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Assert.assertNull((Object)consumer.receive(2000L));
    }

    private void produceMessages() throws Exception {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost?create=false");
        Connection connection = cf.createConnection();
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue(this.name.getMethodName());
        MessageProducer producer = session.createProducer((Destination)queue);
        for (int i = 0; i < 5; ++i) {
            producer.send((Message)session.createTextMessage("test:" + i));
        }
        connection.close();
    }
}

