/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.memory;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.Connection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.store.AbstractMessageStoreSizeStatTest;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.memory.MemoryPersistenceAdapter;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryMessageStoreSizeStatTest
extends AbstractMessageStoreSizeStatTest {
    protected static final Logger LOG = LoggerFactory.getLogger(MemoryMessageStoreSizeStatTest.class);

    @Override
    protected void initPersistence(BrokerService brokerService) throws IOException {
        this.broker.setPersistent(false);
        this.broker.setPersistenceAdapter((PersistenceAdapter)new MemoryPersistenceAdapter());
    }

    @Override
    @Test(timeout=30000L)
    public void testMessageSizeOneDurable() throws Exception {
        AtomicLong publishedMessageSize = new AtomicLong();
        Connection connection = new ActiveMQConnectionFactory(this.brokerConnectURI).createConnection();
        connection.setClientID("clientId");
        connection.start();
        Destination dest = this.publishTestMessagesDurable(connection, new String[]{"sub1"}, 200, 100, publishedMessageSize);
        this.verifyStats(dest, 100, 10000L);
        this.consumeDurableTestMessages(connection, "sub1", 100, publishedMessageSize);
        this.verifyStats(dest, 100, publishedMessageSize.get());
        connection.stop();
    }

    @Override
    @Test(timeout=30000L)
    public void testMessageSizeTwoDurables() throws Exception {
        AtomicLong publishedMessageSize = new AtomicLong();
        Connection connection = new ActiveMQConnectionFactory(this.brokerConnectURI).createConnection();
        connection.setClientID("clientId");
        connection.start();
        Destination dest = this.publishTestMessagesDurable(connection, new String[]{"sub1", "sub2"}, 200, 100, publishedMessageSize);
        this.verifyStats(dest, 100, 10000L);
        this.consumeDurableTestMessages(connection, "sub1", 100, publishedMessageSize);
        this.verifyStats(dest, 100, publishedMessageSize.get());
        connection.stop();
    }
}

