/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.test;

import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.test.JmsTopicSendReceiveWithTwoConnectionsAndEmbeddedBrokerTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsTopicSendReceiveWithEmbeddedBrokerAndUserIDTest
extends JmsTopicSendReceiveWithTwoConnectionsAndEmbeddedBrokerTest {
    private static final Logger LOG = LoggerFactory.getLogger(JmsTopicSendReceiveWithEmbeddedBrokerAndUserIDTest.class);
    protected String userName = "James";

    @Override
    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory answer = super.createConnectionFactory();
        answer.setUserName(this.userName);
        return answer;
    }

    @Override
    protected TransportConnector configureBroker(BrokerService answer) throws Exception {
        answer.setPopulateJMSXUserID(true);
        return super.configureBroker(answer);
    }

    @Override
    protected void assertMessagesReceivedAreValid(List<Message> receivedMessages) throws JMSException {
        super.assertMessagesReceivedAreValid(receivedMessages);
        for (Message message : receivedMessages) {
            String userID = message.getStringProperty("JMSXUserID");
            LOG.info("Received message with userID: " + userID);
            JmsTopicSendReceiveWithEmbeddedBrokerAndUserIDTest.assertEquals((String)"JMSXUserID header", (String)this.userName, (String)userID);
        }
    }

    protected void assertMessagesAreReceived2() throws JMSException {
        this.waitForMessagesToBeDelivered();
        this.assertMessagesReceivedAreValid2(this.messages);
    }

    protected void assertMessagesReceivedAreValid2(List<Message> receivedMessages) throws JMSException {
        super.assertMessagesReceivedAreValid(receivedMessages);
        for (Message message : receivedMessages) {
            String userID = (String)message.getObjectProperty("JMSXUserID");
            LOG.info("Received message with userID: " + userID);
            JmsTopicSendReceiveWithEmbeddedBrokerAndUserIDTest.assertEquals((String)"JMSXUserID header", (String)this.userName, (String)userID);
        }
    }

    public void testSpoofedJMSXUserIdIsIgnored() throws Exception {
        for (int i = 0; i < this.data.length; ++i) {
            Message message = this.createMessage(i);
            this.configureMessage(message);
            message.setStringProperty("JMSXUserID", "spoofedId");
            if (this.verbose) {
                LOG.info("About to send a message: " + message + " with text: " + this.data[i]);
            }
            this.sendMessage(i, message);
        }
        this.assertMessagesAreReceived();
        LOG.info("" + this.data.length + " messages(s) received, closing down connections");
    }

    public void testSpoofedJMSXUserIdIsIgnoredAsObjectProperty() throws Exception {
        for (int i = 0; i < this.data.length; ++i) {
            Message message = this.createMessage(i);
            this.configureMessage(message);
            message.setStringProperty("JMSXUserID", "spoofedId");
            if (this.verbose) {
                LOG.info("About to send a message: " + message + " with text: " + this.data[i]);
            }
            this.sendMessage(i, message);
        }
        this.assertMessagesAreReceived2();
        LOG.info("" + this.data.length + " messages(s) received, closing down connections");
    }
}

