/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usage;

import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.BaseDestination;
import org.apache.activemq.util.ProducerThread;
import org.apache.activemq.util.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreUsageTest
extends EmbeddedBrokerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(StoreUsageTest.class);

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = super.createBroker();
        broker.getSystemUsage().getStoreUsage().setLimit(34816L);
        broker.deleteAllMessages();
        return broker;
    }

    @Override
    protected boolean isPersistent() {
        return true;
    }

    public void testJmx() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
        Connection conn = factory.createConnection();
        conn.start();
        Session sess = conn.createSession(false, 1);
        Queue dest = sess.createQueue(((Object)((Object)this)).getClass().getName());
        final ProducerThread producer = new ProducerThread(sess, (Destination)dest);
        producer.start();
        StoreUsageTest.assertTrue((String)"some messages sent", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition((Destination)dest){
            final /* synthetic */ Destination val$dest;
            {
                this.val$dest = destination;
            }

            public boolean isSatisified() throws Exception {
                BaseDestination baseDestination = (BaseDestination)StoreUsageTest.this.broker.getRegionBroker().getDestinationMap().get(this.val$dest);
                return baseDestination != null && baseDestination.getDestinationStatistics().getEnqueues().getCount() > 0L;
            }
        }));
        BaseDestination baseDestination = (BaseDestination)this.broker.getRegionBroker().getDestinationMap().get(dest);
        LOG.info("Sent u: " + baseDestination.getDestinationStatistics().getEnqueues());
        int sent = 0;
        do {
            sent = producer.getSentCount();
            TimeUnit.SECONDS.sleep(1L);
            LOG.info("Sent: " + sent);
        } while (sent != producer.getSentCount());
        LOG.info("Increasing limit! enqueues: " + baseDestination.getDestinationStatistics().getEnqueues().getCount());
        this.broker.getAdminView().setStoreLimit(0x100000L);
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return producer.getSentCount() == producer.getMessageCount();
            }
        });
        StoreUsageTest.assertEquals((String)"Producer sent all messages", (int)producer.getMessageCount(), (int)producer.getSentCount());
        StoreUsageTest.assertEquals((String)"Enqueues match sent", (long)producer.getSentCount(), (long)baseDestination.getDestinationStatistics().getEnqueues().getCount());
    }
}

