/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.spring.ConsumerBean;

public class StartAndStopClientAndBrokerDoesNotLeaveThreadsRunningTest
extends TestCase {
    public void setUp() throws Exception {
    }

    public void testStartAndStopClientAndBrokerAndCheckNoThreadsAreLeft() throws Exception {
        this.runTest(new Task(){

            @Override
            public void execute() throws Exception {
                BrokerService broker = new BrokerService();
                broker.setPersistent(false);
                broker.start();
                ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
                Connection connection = factory.createConnection();
                connection.start();
                Session session = connection.createSession(false, 1);
                Queue destination = session.createQueue(StartAndStopClientAndBrokerDoesNotLeaveThreadsRunningTest.this.getName());
                MessageConsumer consumer = session.createConsumer((Destination)destination);
                ConsumerBean listener = new ConsumerBean();
                consumer.setMessageListener((MessageListener)listener);
                MessageProducer producer = session.createProducer((Destination)destination);
                TextMessage message = session.createTextMessage("Hello World!");
                producer.send((Message)message);
                producer.close();
                listener.assertMessagesArrived(1);
                consumer.close();
                session.close();
                connection.close();
                broker.stop();
            }
        });
    }

    public void runTest(Task task) throws Exception {
        int before = Thread.currentThread().getThreadGroup().activeCount();
        task.execute();
        Thread.yield();
        Thread.sleep(5000L);
        int after = Thread.currentThread().getThreadGroup().activeCount();
        int diff = Math.abs(before - after);
        StartAndStopClientAndBrokerDoesNotLeaveThreadsRunningTest.assertTrue((String)("Should be at most one more thread. Diff = " + diff), (diff + 1 <= after ? 1 : 0) != 0);
    }

    public static interface Task {
        public void execute() throws Exception;
    }
}

