/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.xbean;

import java.net.URI;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.network.NetworkConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorXBeanConfigTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectorXBeanConfigTest.class);
    protected BrokerService brokerService;

    public void testConnectorConfiguredCorrectly() throws Exception {
        TransportConnector connector = (TransportConnector)this.brokerService.getTransportConnectors().get(0);
        ConnectorXBeanConfigTest.assertEquals((Object)new URI("tcp://localhost:61636"), (Object)connector.getUri());
        ConnectorXBeanConfigTest.assertTrue((connector.getTaskRunnerFactory() == this.brokerService.getTaskRunnerFactory() ? 1 : 0) != 0);
        NetworkConnector netConnector = (NetworkConnector)this.brokerService.getNetworkConnectors().get(0);
        List excludedDestinations = netConnector.getExcludedDestinations();
        ConnectorXBeanConfigTest.assertEquals((Object)new ActiveMQQueue("exclude.test.foo"), excludedDestinations.get(0));
        ConnectorXBeanConfigTest.assertEquals((Object)new ActiveMQTopic("exclude.test.bar"), excludedDestinations.get(1));
        List dynamicallyIncludedDestinations = netConnector.getDynamicallyIncludedDestinations();
        ConnectorXBeanConfigTest.assertEquals((Object)new ActiveMQQueue("include.test.foo"), dynamicallyIncludedDestinations.get(0));
        ConnectorXBeanConfigTest.assertEquals((Object)new ActiveMQTopic("include.test.bar"), dynamicallyIncludedDestinations.get(1));
    }

    public void testBrokerRestartIsAllowed() throws Exception {
        this.brokerService.stop();
        this.brokerService.waitUntilStopped();
        this.brokerService.start();
        ConnectorXBeanConfigTest.assertTrue((String)"mapped address in published address", (boolean)this.brokerService.getTransportConnectorByScheme("tcp").getPublishableConnectString().contains("Mapped"));
    }

    public void testForceBrokerRestart() throws Exception {
        this.brokerService.stop();
        this.brokerService.waitUntilStopped();
        this.brokerService.start(true);
        this.brokerService.waitUntilStarted();
        LOG.info("try and connect to restarted broker");
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:61636");
        Connection conn = factory.createConnection();
        Session sess = conn.createSession(false, 1);
        conn.start();
        ActiveMQQueue dest = new ActiveMQQueue("test");
        MessageConsumer consumer = sess.createConsumer((Destination)dest);
        MessageProducer producer = sess.createProducer((Destination)dest);
        producer.send((Message)sess.createTextMessage("test"));
        TextMessage msg = (TextMessage)consumer.receive(1000L);
        ConnectorXBeanConfigTest.assertEquals((String)"test", (String)msg.getText());
    }

    public void testBrokerWontStop() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost?async=false");
        factory.setDispatchAsync(false);
        factory.setAlwaysSessionAsync(false);
        Connection conn = factory.createConnection();
        final Session sess = conn.createSession(false, 2);
        conn.start();
        ActiveMQQueue dest = new ActiveMQQueue("TEST");
        final CountDownLatch stop = new CountDownLatch(1);
        final CountDownLatch sendSecond = new CountDownLatch(1);
        CountDownLatch shutdown = new CountDownLatch(1);
        CountDownLatch test = new CountDownLatch(1);
        ActiveMQConnectionFactory testFactory = new ActiveMQConnectionFactory("vm://localhost?async=false");
        Connection testConn = testFactory.createConnection();
        testConn.start();
        Queue testDestination = sess.createQueue("NEW");
        Session testSess = testConn.createSession(false, 1);
        MessageProducer testProducer = testSess.createProducer((Destination)testDestination);
        Thread consumerThread2 = new Thread((Destination)dest, sendSecond, stop, test, shutdown){
            final /* synthetic */ Destination val$dest;
            final /* synthetic */ CountDownLatch val$sendSecond;
            final /* synthetic */ CountDownLatch val$stop;
            final /* synthetic */ CountDownLatch val$test;
            final /* synthetic */ CountDownLatch val$shutdown;
            {
                this.val$dest = destination;
                this.val$sendSecond = countDownLatch;
                this.val$stop = countDownLatch2;
                this.val$test = countDownLatch3;
                this.val$shutdown = countDownLatch4;
            }

            @Override
            public void run() {
                try {
                    MessageProducer producer = sess.createProducer(this.val$dest);
                    producer.send((Message)sess.createTextMessage("msg1"));
                    MessageConsumer consumer = sess.createConsumer(this.val$dest);
                    consumer.setMessageListener(new MessageListener(){

                        public void onMessage(Message message) {
                            try {
                                Thread.sleep(2000L);
                                val$sendSecond.countDown();
                                Thread.sleep(5000L);
                                val$stop.countDown();
                                Thread.sleep(5000L);
                                val$test.countDown();
                                val$shutdown.await();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        consumerThread2.start();
        Thread producerThread2 = new Thread((Destination)dest){
            final /* synthetic */ Destination val$dest;
            {
                this.val$dest = destination;
            }

            @Override
            public void run() {
                try {
                    sendSecond.await();
                    MessageProducer producer = sess.createProducer(this.val$dest);
                    producer.send((Message)sess.createTextMessage("msg2"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        producerThread2.start();
        Thread stopThread = new Thread(){

            @Override
            public void run() {
                try {
                    stop.await();
                    ConnectorXBeanConfigTest.this.brokerService.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        stopThread.start();
        test.await();
        try {
            testSess.createConsumer((Destination)testDestination);
            ConnectorXBeanConfigTest.fail((String)"Should have failed creating a consumer!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            testProducer.send((Message)testSess.createTextMessage("msg3"));
            ConnectorXBeanConfigTest.fail((String)"Should have failed sending a message!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        shutdown.countDown();
    }

    protected void setUp() throws Exception {
        this.brokerService = this.createBroker();
        this.brokerService.start();
    }

    protected void tearDown() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
        }
    }

    protected BrokerService createBroker() throws Exception {
        String uri = "org/apache/activemq/xbean/connector-test.xml";
        return BrokerFactory.createBroker((URI)new URI("xbean:" + uri));
    }
}

