/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.mqtt;

import org.apache.activemq.apollo.broker.Broker$;
import org.apache.activemq.apollo.broker.Connector;
import org.apache.activemq.apollo.broker.protocol.ProtocolCodecFactory;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtdispatch.transport.ProtocolCodec;
import org.fusesource.mqtt.codec.MQTTProtocolCodec;

public class MqttProtocolCodecFactory
implements ProtocolCodecFactory.Provider {
    static final String id = "mqtt";
    static final Buffer HEAD_MAGIC = new Buffer(new byte[]{16});
    static final Buffer MQTT31_TAIL_MAGIC = new Buffer(new byte[]{0, 6, 77, 81, 73, 115, 100, 112});
    static final Buffer MQTT311_TAIL_MAGIC = new Buffer(new byte[]{0, 4, 77, 81, 84, 84});

    public String id() {
        return id;
    }

    public ProtocolCodec createProtocolCodec(Connector connector) {
        MQTTProtocolCodec rc = new MQTTProtocolCodec();
        rc.setBufferPools(Broker$.MODULE$.buffer_pools());
        return rc;
    }

    public boolean isIdentifiable() {
        return true;
    }

    public int maxIdentificaionLength() {
        return 13;
    }

    public boolean matchesIdentification(Buffer header) {
        if (header.length < 10) {
            return false;
        }
        return header.startsWith(HEAD_MAGIC) && (header.indexOf(MQTT31_TAIL_MAGIC, 2) < 6 || header.indexOf(MQTT311_TAIL_MAGIC, 2) < 6);
    }
}

