/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.proton.converter.jms;

import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.StreamMessage;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.core.message.impl.MessageInternal;
import org.apache.activemq.artemis.core.protocol.proton.converter.jms.ServerJMSMessage;
import org.apache.activemq.artemis.reader.StreamMessageUtil;

public final class ServerJMSStreamMessage
extends ServerJMSMessage
implements StreamMessage {
    public static final byte TYPE = 6;
    private int bodyLength = 0;
    private int len = 0;

    public ServerJMSStreamMessage(MessageInternal message, int deliveryCount) {
        super(message, deliveryCount);
    }

    public boolean readBoolean() throws JMSException {
        try {
            return StreamMessageUtil.streamReadBoolean((ActiveMQBuffer)this.getReadBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new MessageFormatException(e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public byte readByte() throws JMSException {
        try {
            return StreamMessageUtil.streamReadByte((ActiveMQBuffer)this.getReadBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new MessageFormatException(e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public short readShort() throws JMSException {
        try {
            return StreamMessageUtil.streamReadShort((ActiveMQBuffer)this.getReadBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new MessageFormatException(e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public char readChar() throws JMSException {
        try {
            return StreamMessageUtil.streamReadChar((ActiveMQBuffer)this.getReadBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new MessageFormatException(e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public int readInt() throws JMSException {
        try {
            return StreamMessageUtil.streamReadInteger((ActiveMQBuffer)this.getReadBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new MessageFormatException(e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public long readLong() throws JMSException {
        try {
            return StreamMessageUtil.streamReadLong((ActiveMQBuffer)this.getReadBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new MessageFormatException(e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public float readFloat() throws JMSException {
        try {
            return StreamMessageUtil.streamReadFloat((ActiveMQBuffer)this.getReadBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new MessageFormatException(e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public double readDouble() throws JMSException {
        try {
            return StreamMessageUtil.streamReadDouble((ActiveMQBuffer)this.getReadBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new MessageFormatException(e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public String readString() throws JMSException {
        try {
            return StreamMessageUtil.streamReadString((ActiveMQBuffer)this.getReadBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new MessageFormatException(e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        try {
            Pair pairRead = StreamMessageUtil.streamReadBytes((ActiveMQBuffer)this.getReadBodyBuffer(), (int)this.len, (byte[])value);
            this.len = (Integer)pairRead.getA();
            return (Integer)pairRead.getB();
        }
        catch (IllegalStateException e) {
            throw new MessageFormatException(e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public Object readObject() throws JMSException {
        if (this.getReadBodyBuffer().readerIndex() >= this.message.getEndOfBodyPosition()) {
            throw new MessageEOFException("");
        }
        try {
            return StreamMessageUtil.streamReadObject((ActiveMQBuffer)this.getReadBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new MessageFormatException(e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.getWriteBodyBuffer().writeByte((byte)2);
        this.getWriteBodyBuffer().writeBoolean(value);
    }

    public void writeByte(byte value) throws JMSException {
        this.getWriteBodyBuffer().writeByte((byte)3);
        this.getWriteBodyBuffer().writeByte(value);
    }

    public void writeShort(short value) throws JMSException {
        this.getWriteBodyBuffer().writeByte((byte)5);
        this.getWriteBodyBuffer().writeShort(value);
    }

    public void writeChar(char value) throws JMSException {
        this.getWriteBodyBuffer().writeByte((byte)11);
        this.getWriteBodyBuffer().writeShort((short)value);
    }

    public void writeInt(int value) throws JMSException {
        this.getWriteBodyBuffer().writeByte((byte)6);
        this.getWriteBodyBuffer().writeInt(value);
    }

    public void writeLong(long value) throws JMSException {
        this.getWriteBodyBuffer().writeByte((byte)7);
        this.getWriteBodyBuffer().writeLong(value);
    }

    public void writeFloat(float value) throws JMSException {
        this.getWriteBodyBuffer().writeByte((byte)8);
        this.getWriteBodyBuffer().writeInt(Float.floatToIntBits(value));
    }

    public void writeDouble(double value) throws JMSException {
        this.getWriteBodyBuffer().writeByte((byte)9);
        this.getWriteBodyBuffer().writeLong(Double.doubleToLongBits(value));
    }

    public void writeString(String value) throws JMSException {
        this.getWriteBodyBuffer().writeByte((byte)10);
        this.getWriteBodyBuffer().writeNullableString(value);
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.getWriteBodyBuffer().writeByte((byte)4);
        this.getWriteBodyBuffer().writeInt(value.length);
        this.getWriteBodyBuffer().writeBytes(value);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.getWriteBodyBuffer().writeByte((byte)4);
        this.getWriteBodyBuffer().writeInt(length);
        this.getWriteBodyBuffer().writeBytes(value, offset, length);
    }

    public void writeObject(Object value) throws JMSException {
        if (value instanceof String) {
            this.writeString((String)value);
        } else if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value == null) {
            this.writeString(null);
        } else {
            throw new MessageFormatException("Invalid object type: " + value.getClass());
        }
    }

    public void reset() throws JMSException {
        this.getWriteBodyBuffer().resetReaderIndex();
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.getWriteBodyBuffer().clear();
    }

    @Override
    public void decode() throws Exception {
        super.decode();
    }

    @Override
    public void encode() throws Exception {
        super.encode();
        this.bodyLength = this.message.getEndOfBodyPosition();
    }
}

