/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.converter;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageIdHelper;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageSupport;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSBytesMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSMapMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSObjectMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSStreamMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSTextMessage;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPIllegalStateException;
import org.apache.activemq.artemis.protocol.amqp.util.NettyWritable;
import org.apache.activemq.artemis.protocol.amqp.util.TLSEncode;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.activemq.artemis.spi.core.protocol.EmbedMessageUtil;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.jboss.logging.Logger;

public class CoreAmqpConverter {
    private static Logger logger = Logger.getLogger(CoreAmqpConverter.class);

    public static AMQPMessage checkAMQP(Message message) throws Exception {
        if (message instanceof AMQPMessage) {
            return (AMQPMessage)message;
        }
        return CoreAmqpConverter.fromCore(message.toCore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AMQPMessage fromCore(ICoreMessage coreMessage) throws Exception {
        long timeStamp;
        long expiration;
        String correlationId;
        Destination replyTo;
        Destination destination;
        String messageId;
        String type;
        byte priority;
        ServerJMSMessage message;
        if (coreMessage == null) {
            return null;
        }
        if (coreMessage.isServerMessage() && coreMessage.isLargeMessage() && coreMessage.getType() == 7 && (message = EmbedMessageUtil.extractEmbedded((ICoreMessage)coreMessage)) instanceof AMQPMessage) {
            return (AMQPMessage)((Object)message);
        }
        message = ServerJMSMessage.wrapCoreMessage(coreMessage);
        message.decode();
        long messageFormat = 0L;
        Header header = null;
        Properties properties = new Properties();
        HashMap<Symbol, Object> daMap = null;
        HashMap<Symbol, Object> maMap = new HashMap<Symbol, Object>();
        HashMap<String, Object> apMap = null;
        HashMap<String, Object> footerMap = null;
        Section body = CoreAmqpConverter.convertBody(message, maMap, properties);
        if (message.getInnerMessage().isDurable()) {
            if (header == null) {
                header = new Header();
            }
            header.setDurable(Boolean.valueOf(true));
        }
        if ((priority = (byte)message.getJMSPriority()) != 4) {
            if (header == null) {
                header = new Header();
            }
            header.setPriority(UnsignedByte.valueOf((byte)priority));
        }
        if ((type = message.getJMSType()) != null) {
            properties.setSubject(type);
        }
        if ((messageId = message.getJMSMessageID()) != null) {
            try {
                properties.setMessageId(AMQPMessageIdHelper.INSTANCE.toIdObject(messageId));
            }
            catch (ActiveMQAMQPIllegalStateException e) {
                properties.setMessageId((Object)messageId);
            }
        }
        if ((destination = message.getJMSDestination()) != null) {
            properties.setTo(AMQPMessageSupport.toAddress(destination));
            maMap.put(AMQPMessageSupport.JMS_DEST_TYPE_MSG_ANNOTATION, CoreAmqpConverter.destinationType(destination));
        }
        if ((replyTo = message.getJMSReplyTo()) != null) {
            properties.setReplyTo(AMQPMessageSupport.toAddress(replyTo));
            maMap.put(AMQPMessageSupport.JMS_REPLY_TO_TYPE_MSG_ANNOTATION, CoreAmqpConverter.destinationType(replyTo));
        }
        if ((correlationId = message.getJMSCorrelationID()) != null) {
            try {
                properties.setCorrelationId(AMQPMessageIdHelper.INSTANCE.toIdObject(correlationId));
            }
            catch (ActiveMQAMQPIllegalStateException e) {
                properties.setCorrelationId((Object)correlationId);
            }
        }
        if ((expiration = message.getJMSExpiration()) != 0L) {
            long ttl = expiration - System.currentTimeMillis();
            if (ttl < 0L) {
                ttl = 1L;
            }
            if (header == null) {
                header = new Header();
            }
            header.setTtl(new UnsignedInteger((int)ttl));
            properties.setAbsoluteExpiryTime(new Date(expiration));
        }
        if ((timeStamp = message.getJMSTimestamp()) != 0L) {
            properties.setCreationTime(new Date(timeStamp));
        }
        Set keySet = MessageUtil.getPropertyNames((Message)message.getInnerMessage());
        for (String key : keySet) {
            Object objectProperty;
            String value;
            if (key.startsWith("JMSX")) {
                if (key.equals("JMSXUserID")) {
                    value = message.getStringProperty(key);
                    properties.setUserId(new Binary(value.getBytes(StandardCharsets.UTF_8)));
                    continue;
                }
                if (key.equals("JMSXGroupID")) {
                    value = message.getStringProperty(key);
                    properties.setGroupId(value);
                    continue;
                }
                if (key.equals("JMSXGroupSeq")) {
                    value = new UnsignedInteger(message.getIntProperty(key));
                    properties.setGroupSequence((UnsignedInteger)value);
                    continue;
                }
            } else if (key.startsWith("JMS_AMQP_")) {
                String name;
                if (key.equals("JMS_AMQP_NATIVE")) continue;
                if (key.equals("JMS_AMQP_FirstAcquirer")) {
                    if (header == null) {
                        header = new Header();
                    }
                    header.setFirstAcquirer(Boolean.valueOf(message.getBooleanProperty(key)));
                    continue;
                }
                if (key.equals("JMS_AMQP_HEADER")) {
                    if (header != null) continue;
                    header = new Header();
                    continue;
                }
                if (key.equals("JMS_AMQP_HEADERDURABLE")) {
                    if (header == null) {
                        header = new Header();
                    }
                    header.setDurable(Boolean.valueOf(message.getInnerMessage().isDurable()));
                    continue;
                }
                if (key.equals("JMS_AMQP_HEADERPRIORITY")) {
                    if (header == null) {
                        header = new Header();
                    }
                    header.setPriority(UnsignedByte.valueOf((byte)priority));
                    continue;
                }
                if (key.startsWith("JMS_AMQP_PROPERTIES")) continue;
                if (key.startsWith("JMS_AMQP_DA_")) {
                    if (daMap == null) {
                        daMap = new HashMap<Symbol, Object>();
                    }
                    name = key.substring("JMS_AMQP_DA_".length());
                    daMap.put(Symbol.valueOf((String)name), message.getObjectProperty(key));
                    continue;
                }
                if (key.startsWith("JMS_AMQP_MA_")) {
                    name = key.substring("JMS_AMQP_MA_".length());
                    maMap.put(Symbol.valueOf((String)name), message.getObjectProperty(key));
                    continue;
                }
                if (key.equals("JMS_AMQP_ContentType")) {
                    properties.setContentType(Symbol.getSymbol((String)message.getStringProperty(key)));
                    continue;
                }
                if (key.equals("JMS_AMQP_ContentEncoding")) {
                    properties.setContentEncoding(Symbol.getSymbol((String)message.getStringProperty(key)));
                    continue;
                }
                if (key.equals("JMS_AMQP_ReplyToGroupID")) {
                    properties.setReplyToGroupId(message.getStringProperty(key));
                    continue;
                }
                if (key.startsWith("JMS_AMQP_FT_")) {
                    if (footerMap == null) {
                        footerMap = new HashMap<String, Object>();
                    }
                    name = key.substring("JMS_AMQP_FT_".length());
                    footerMap.put(name, message.getObjectProperty(key));
                    continue;
                }
            } else {
                if (key.equals("_AMQ_GROUP_ID")) {
                    value = message.getStringProperty(key);
                    properties.setGroupId(value);
                    continue;
                }
                if (key.equals("NATIVE_MESSAGE_ID") || key.endsWith(Message.HDR_SCHEDULED_DELIVERY_TIME.toString())) continue;
            }
            if (apMap == null) {
                apMap = new HashMap<String, Object>();
            }
            if ((objectProperty = message.getObjectProperty(key)) instanceof byte[]) {
                objectProperty = new Binary((byte[])objectProperty);
            }
            apMap.put(key, objectProperty);
        }
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.heapBuffer(1024);
        try {
            EncoderImpl encoder = TLSEncode.getEncoder();
            encoder.setByteBuffer((WritableBuffer)new NettyWritable(buffer));
            if (header != null) {
                encoder.writeObject((Object)header);
            }
            if (daMap != null) {
                encoder.writeObject((Object)new DeliveryAnnotations(daMap));
            }
            if (maMap != null) {
                encoder.writeObject((Object)new MessageAnnotations(maMap));
            }
            if (properties != null) {
                encoder.writeObject((Object)properties);
            }
            if (apMap != null) {
                encoder.writeObject((Object)new ApplicationProperties(apMap));
            }
            if (body != null) {
                encoder.writeObject((Object)body);
            }
            if (footerMap != null) {
                encoder.writeObject((Object)new Footer(footerMap));
            }
            byte[] data = new byte[buffer.writerIndex()];
            buffer.readBytes(data);
            AMQPMessage amqpMessage = new AMQPMessage(messageFormat, data, null);
            amqpMessage.setMessageID(message.getInnerMessage().getMessageID());
            amqpMessage.setReplyTo(coreMessage.getReplyTo());
            AMQPMessage aMQPMessage = amqpMessage;
            return aMQPMessage;
        }
        finally {
            TLSEncode.getEncoder().setByteBuffer((WritableBuffer)null);
            buffer.release();
        }
    }

    private static Section convertBody(ServerJMSMessage message, Map<Symbol, Object> maMap, Properties properties) throws JMSException {
        AmqpValue body = null;
        if (message instanceof ServerJMSBytesMessage) {
            Binary payload = CoreAmqpConverter.getBinaryFromMessageBody((ServerJMSBytesMessage)message);
            maMap.put(AMQPMessageSupport.JMS_MSG_TYPE, (byte)3);
            if (payload == null) {
                payload = AMQPMessageSupport.EMPTY_BINARY;
            } else {
                body = new AmqpValue((Object)payload);
            }
        } else if (message instanceof ServerJMSTextMessage) {
            body = new AmqpValue((Object)((TextMessage)message).getText());
            maMap.put(AMQPMessageSupport.JMS_MSG_TYPE, (byte)5);
        } else if (message instanceof ServerJMSMapMessage) {
            body = new AmqpValue(CoreAmqpConverter.getMapFromMessageBody((ServerJMSMapMessage)message));
            maMap.put(AMQPMessageSupport.JMS_MSG_TYPE, (byte)2);
        } else if (message instanceof ServerJMSStreamMessage) {
            maMap.put(AMQPMessageSupport.JMS_MSG_TYPE, (byte)4);
            ArrayList<Object> list = new ArrayList<Object>();
            ServerJMSStreamMessage m = (ServerJMSStreamMessage)message;
            try {
                while (true) {
                    list.add(m.readObject());
                }
            }
            catch (MessageEOFException messageEOFException) {
                body = new AmqpSequence(list);
            }
        } else if (message instanceof ServerJMSObjectMessage) {
            properties.setContentType(AMQPMessageSupport.SERIALIZED_JAVA_OBJECT_CONTENT_TYPE);
            maMap.put(AMQPMessageSupport.JMS_MSG_TYPE, (byte)1);
            Binary payload = CoreAmqpConverter.getBinaryFromMessageBody((ServerJMSObjectMessage)message);
            if (payload == null) {
                payload = AMQPMessageSupport.EMPTY_BINARY;
            }
            body = new Data(payload);
            if (!message.propertyExists("JMS_AMQP_ContentType")) {
                message.setStringProperty("JMS_AMQP_ContentType", AMQPMessageSupport.SERIALIZED_JAVA_OBJECT_CONTENT_TYPE.toString());
            }
        } else if (message instanceof ServerJMSMessage) {
            maMap.put(AMQPMessageSupport.JMS_MSG_TYPE, (byte)0);
            ICoreMessage internalMessage = message.getInnerMessage();
            ActiveMQBuffer buffer = internalMessage.getDataBuffer();
            try {
                SimpleString s = buffer.readNullableSimpleString();
                if (s != null) {
                    body = new AmqpValue((Object)s.toString());
                }
            }
            catch (Throwable ignored) {
                logger.debug("Exception ignored during conversion", (Object)ignored.getMessage(), ignored);
                body = new AmqpValue((Object)"Conversion to AMQP error!");
            }
        }
        return body;
    }

    private static Binary getBinaryFromMessageBody(ServerJMSBytesMessage message) throws JMSException {
        byte[] data = new byte[(int)message.getBodyLength()];
        message.readBytes(data);
        message.reset();
        return new Binary(data);
    }

    private static Binary getBinaryFromMessageBody(ServerJMSObjectMessage message) throws JMSException {
        return message.getSerializedForm();
    }

    private static Map<String, Object> getMapFromMessageBody(ServerJMSMapMessage message) throws JMSException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Enumeration names = message.getMapNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            Object value = message.getObject(key);
            if (value instanceof byte[]) {
                value = new Binary((byte[])value);
            }
            map.put(key, value);
        }
        return map;
    }

    private static byte destinationType(Destination destination) {
        if (destination instanceof Queue) {
            if (destination instanceof TemporaryQueue) {
                return 2;
            }
            return 0;
        }
        if (destination instanceof Topic) {
            if (destination instanceof TemporaryTopic) {
                return 3;
            }
            return 1;
        }
        throw new IllegalArgumentException("Unknown Destination Type passed to JMS Transformer.");
    }
}

