/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.transaction.impl;

import java.io.Serializable;
import java.util.Arrays;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.utils.Base64;

public class XidImpl
implements Xid,
Serializable {
    private static final long serialVersionUID = 407053232840068514L;
    private final byte[] branchQualifier;
    private final int formatId;
    private final byte[] globalTransactionId;
    private int hash;
    private boolean hashCalculated;

    public static String toBase64String(Xid xid) {
        byte[] data = XidImpl.toByteArray(xid);
        return Base64.encodeBytes(data, true);
    }

    private static byte[] toByteArray(Xid xid) {
        byte[] branchQualifier = xid.getBranchQualifier();
        byte[] globalTransactionId = xid.getGlobalTransactionId();
        int formatId = xid.getFormatId();
        byte[] hashBytes = new byte[branchQualifier.length + globalTransactionId.length + 4];
        System.arraycopy(branchQualifier, 0, hashBytes, 0, branchQualifier.length);
        System.arraycopy(globalTransactionId, 0, hashBytes, branchQualifier.length, globalTransactionId.length);
        byte[] intBytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            intBytes[i] = (byte)((formatId >> i * 8) % 255);
        }
        System.arraycopy(intBytes, 0, hashBytes, branchQualifier.length + globalTransactionId.length, 4);
        return hashBytes;
    }

    public XidImpl(byte[] branchQualifier, int formatId, byte[] globalTransactionId) {
        this.branchQualifier = branchQualifier;
        this.formatId = formatId;
        this.globalTransactionId = globalTransactionId;
    }

    public XidImpl(Xid other) {
        this.branchQualifier = this.copyBytes(other.getBranchQualifier());
        this.formatId = other.getFormatId();
        this.globalTransactionId = this.copyBytes(other.getGlobalTransactionId());
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    public int hashCode() {
        if (!this.hashCalculated) {
            this.hash = Arrays.hashCode(XidImpl.toByteArray(this));
            this.hashCalculated = true;
        }
        return this.hash;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Xid)) {
            return false;
        }
        Xid xother = (Xid)other;
        return this.formatId == xother.getFormatId() && Arrays.equals(this.branchQualifier, xother.getBranchQualifier()) && Arrays.equals(this.globalTransactionId, xother.getGlobalTransactionId());
    }

    public String toString() {
        return "XidImpl (" + System.identityHashCode(this) + " bq:" + this.stringRep(this.branchQualifier) + " formatID:" + this.formatId + " gtxid:" + this.stringRep(this.globalTransactionId) + " base64:" + XidImpl.toBase64String(this);
    }

    private String stringRep(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            builder.append(b);
            if (i == bytes.length - 1) continue;
            builder.append('.');
        }
        return builder.toString();
    }

    private byte[] copyBytes(byte[] other) {
        byte[] bytes = new byte[other.length];
        System.arraycopy(other, 0, bytes, 0, other.length);
        return bytes;
    }
}

