/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.tests;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class NioServerPerfTest {
    protected ServerSocketChannel ch;
    protected Selector selector;
    protected volatile boolean running = true;
    protected ByteBuffer buffer;
    protected final AtomicLong total_bytes_received = new AtomicLong(0L);
    protected final AtomicLong total_msgs = new AtomicLong(0L);
    protected final AtomicLong start = new AtomicLong(0L);
    public static final long BYTES_TO_SEND = 10000000L;
    public static final int SIZE = 1000;

    protected static ByteBuffer create(int size, boolean direct) {
        return direct ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
    }

    protected void start(boolean direct) throws Exception {
        this.selector = Selector.open();
        this.ch = ServerSocketChannel.open();
        this.ch.bind(new InetSocketAddress("0.0.0.0", 7500));
        this.ch.configureBlocking(false);
        this.ch.register(this.selector, 16, null);
        System.out.println("-- server ready");
        while (this.running) {
            this.selector.select();
            Set<SelectionKey> keys = this.selector.selectedKeys();
            Iterator<SelectionKey> it = keys.iterator();
            while (it.hasNext()) {
                SelectionKey key = it.next();
                if (!key.isValid()) {
                    it.remove();
                    continue;
                }
                it.remove();
                if (key.isAcceptable()) {
                    SocketChannel client_ch = this.ch.accept();
                    if (client_ch == null) continue;
                    System.out.printf("accepted connection from %s\n", client_ch.getRemoteAddress());
                    client_ch.configureBlocking(false);
                    client_ch.register(this.selector, 1, NioServerPerfTest.create(1000, direct));
                    continue;
                }
                if (!key.isReadable() || this.handle((SocketChannel)key.channel(), (ByteBuffer)key.attachment())) continue;
                key.cancel();
                Util.close((Closeable)key.channel());
            }
        }
        Util.close(this.selector, this.ch);
    }

    protected boolean handle(SocketChannel ch, ByteBuffer buf) {
        try {
            int num;
            if (this.start.get() == 0L) {
                this.start.compareAndSet(0L, System.currentTimeMillis());
            }
            if ((num = ch.read(buf)) < 0) {
                return false;
            }
            this.total_bytes_received.addAndGet(num);
            if (!buf.hasRemaining()) {
                this.total_msgs.incrementAndGet();
                buf.rewind();
            }
            if (this.total_bytes_received.get() >= 10000000L) {
                long time = System.currentTimeMillis() - this.start.get();
                double throughput_sec = (double)this.total_bytes_received.get() / ((double)time / 1000.0);
                double msgs_sec = (double)this.total_msgs.get() / ((double)time / 1000.0);
                System.out.printf("\n===========================\nreceived %d messages in %.2f secs: throughput: %s/sec, %.2f msgs/sec\n", this.total_msgs.get(), (double)time / 1000.0, Util.printBytes(throughput_sec), msgs_sec);
                this.start.set(0L);
                this.total_bytes_received.set(0L);
                this.total_msgs.set(0L);
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        boolean direct = false;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-direct")) {
                System.out.println("NioServerPerfTest [-direct true|false]");
                return;
            }
            direct = Boolean.parseBoolean(args[++i]);
        }
        new NioServerPerfTest().start(direct);
    }
}

