/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.tests;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.apache.activemq.artemis.shaded.org.jgroups.Header;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.Version;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.ClassConfigurator;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.PingData;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.PingHeader;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.pbcast.GMS;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.pbcast.JoinRsp;
import org.apache.activemq.artemis.shaded.org.jgroups.util.MessageBatch;
import org.apache.activemq.artemis.shaded.org.jgroups.util.NameCache;
import org.apache.activemq.artemis.shaded.org.jgroups.util.UUID;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class ParseMessages {
    protected static final short GMS_ID = ClassConfigurator.getProtocolId(GMS.class);
    protected static boolean show_views = true;

    public static void parse(byte[] buf, int offset, int length, BiConsumer<Short, Message> msg_consumer, BiConsumer<Short, MessageBatch> batch_consumer, boolean tcp) {
        Util.parse(new ByteArrayInputStream(buf, offset, length), msg_consumer, batch_consumer, tcp);
    }

    public static void parse(InputStream in, BiConsumer<Short, Message> msg_consumer, BiConsumer<Short, MessageBatch> batch_consumer, boolean tcp) throws FileNotFoundException {
        Util.parse(in, msg_consumer, batch_consumer, tcp);
    }

    public static void main(String[] args) throws Exception {
        InputStream in;
        String file = null;
        boolean print_vers = false;
        boolean binary_to_ascii = true;
        boolean parse_discovery_responses = true;
        boolean tcp = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-file")) {
                file = args[++i];
                continue;
            }
            if ("-version".equals(args[i])) {
                print_vers = true;
                continue;
            }
            if ("-tcp".equalsIgnoreCase(args[i])) {
                tcp = true;
                continue;
            }
            if ("-mappings".equalsIgnoreCase(args[i])) {
                ParseMessages.readMappings(args[++i]);
                continue;
            }
            if ("-binary-to-ascii".equalsIgnoreCase(args[i])) {
                binary_to_ascii = Boolean.parseBoolean(args[++i]);
                continue;
            }
            if ("-parse-discovery-responses".equalsIgnoreCase(args[i])) {
                parse_discovery_responses = Boolean.parseBoolean(args[++i]);
                continue;
            }
            if ("-show-views".equalsIgnoreCase(args[i])) {
                show_views = Boolean.parseBoolean(args[++i]);
                continue;
            }
            ParseMessages.help();
            return;
        }
        boolean print_version = print_vers;
        boolean parse = parse_discovery_responses;
        AtomicInteger cnt = new AtomicInteger(1);
        BiConsumer<Short, Message> msg_consumer = (version, msg) -> {
            if (parse) {
                try {
                    ParseMessages.parseDiscoveryResponse(msg);
                }
                catch (Exception e) {
                    System.err.printf("failed parsing discovery response from %s: %s\n", msg.src(), e);
                }
            }
            View view = show_views ? ParseMessages.getView(msg) : null;
            System.out.printf("%d:%s %s, hdrs: %s %s\n", cnt.getAndIncrement(), print_version ? String.format(" [%s]", Version.print(version)) : "", msg, msg.printHeaders(), view == null ? "" : "(view: " + view + ")");
        };
        BiConsumer<Short, MessageBatch> batch_consumer = (version, batch) -> {
            System.out.printf("%d:%s batch to %s from %s (%d messages):\n", cnt.getAndIncrement(), print_version ? String.format(" [%s]", Version.print(version)) : "", batch.dest() != null ? batch.dest() : "<all>", batch.sender(), batch.size());
            int index = 1;
            for (Message msg : batch) {
                if (parse) {
                    try {
                        ParseMessages.parseDiscoveryResponse(msg);
                    }
                    catch (Exception e) {
                        System.err.printf("failed parsing discovery response from %s: %s\n", msg.src(), e);
                    }
                }
                View view = show_views ? ParseMessages.getView(msg) : null;
                System.out.printf("%d:%s %s, hdrs: %s %s\n", cnt.getAndIncrement(), print_version ? String.format(" [%s]", Version.print(version)) : "", msg, msg.printHeaders(), view == null ? "" : "(view: " + view + ")");
                System.out.printf("    %d: [%d bytes%s], hdrs: %s %s\n", index++, msg.getLength(), msg.getFlags() > 0 ? ", flags=" + Util.flagsToString(msg.getFlags()) : "", msg.printHeaders(), view == null ? "" : "(view: " + view + ")");
            }
        };
        InputStream inputStream = in = file != null ? new FileInputStream(file) : System.in;
        if (binary_to_ascii) {
            in = new BinaryToAsciiInputStream(in);
        }
        ParseMessages.parse(in, msg_consumer, batch_consumer, tcp);
    }

    protected static void parseDiscoveryResponse(Message msg) throws IOException, ClassNotFoundException {
        Collection<Header> hdrs = msg.getHeaders().values();
        for (Header hdr : hdrs) {
            if (!(hdr instanceof PingHeader)) continue;
            byte[] payload = msg.getArray();
            if (payload == null) break;
            PingData data = Util.streamableFromBuffer(PingData::new, payload, msg.getOffset(), msg.getLength());
            NameCache.add(data.getAddress(), data.getLogicalName());
            break;
        }
    }

    protected static View getView(Message msg) {
        GMS.GmsHeader hdr = (GMS.GmsHeader)msg.getHeader(GMS_ID);
        if (hdr == null) {
            return null;
        }
        try {
            switch (hdr.getType()) {
                case 5: {
                    return GMS._readViewAndDigest(msg.getArray(), msg.getOffset(), msg.getLength()).getVal1();
                }
                case 2: {
                    return Util.streamableFromBuffer(JoinRsp::new, msg.getArray(), msg.getOffset(), msg.getLength()).getView();
                }
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected static void help() {
        System.out.println("ParseMessages [-version] [-file <filename>] [-mappings <filename>] [-tcp] [-binary-to-ascii true|false] [-parse-discovery-responses true|false]\n[-show-views (true|false)\n\n-file: if missing stdin will be used\n-tcp: when TCP is used, the first 4 bytes (length) is skipped\n-mappings: file containing UUIDs and logical name (1 mapping per line)\n-binary-to-ascii <true|false>: if the input contains binary data, convert it to ASCII (required by ParseMessages) on the fly\n-parse-discovery-responses: if true, discovery responses for UUID-logical addr mappings are parsed. This shows logical names rather than UUIDs, making dumps more legible.\n-show-views: shows the views for VIEW and JOIN_RSP messages");
    }

    protected static void readMappings(String filename) throws IOException {
        try (FileInputStream in = new FileInputStream(filename);){
            while (true) {
                String uuid_str = Util.readToken(in);
                String name = Util.readToken(in);
                if (uuid_str == null) break;
                if (name == null) {
                    break;
                }
                UUID uuid = null;
                try {
                    long tmp = Long.valueOf(uuid_str);
                    uuid = new UUID(0L, tmp);
                }
                catch (Throwable t) {
                    uuid = UUID.fromString(uuid_str);
                }
                NameCache.add(uuid, name);
            }
        }
    }

    protected static class BinaryToAsciiInputStream
    extends InputStream {
        protected final InputStream in;
        protected final byte[] input = new byte[2];

        public BinaryToAsciiInputStream(InputStream in) {
            this.in = in;
        }

        @Override
        public int read() throws IOException {
            this.input[0] = (byte)this.in.read();
            if (this.input[0] == 10 || this.input[0] == 13) {
                return this.read();
            }
            if (this.input[0] < 0) {
                return this.input[0];
            }
            this.input[1] = (byte)this.in.read();
            if (this.input[1] == 10) {
                return this.read();
            }
            if (this.input[1] < 0) {
                return this.input[1];
            }
            String tmp = new String(this.input);
            int val = Integer.parseInt(tmp, 16);
            return (char)val;
        }
    }
}

