/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.Receiver;

public class MyReceiver<T>
implements Receiver,
Closeable {
    protected final List<T> list = new CopyOnWriteArrayList<T>();
    protected String name;
    protected boolean verbose;
    protected boolean raw_msgs;

    @Override
    public void receive(Message msg) {
        Message obj = this.raw_msgs ? msg : msg.getObject();
        this.list.add(obj);
        if (this.verbose) {
            System.out.println((String)(this.name() != null ? this.name() + ":" : "") + " received message from " + msg.getSrc() + ": " + obj);
        }
    }

    public MyReceiver<T> rawMsgs(boolean flag) {
        this.raw_msgs = flag;
        return this;
    }

    public List<T> list() {
        return this.list;
    }

    public MyReceiver<T> verbose(boolean flag) {
        this.verbose = flag;
        return this;
    }

    public String name() {
        return this.name;
    }

    public MyReceiver<T> name(String name) {
        this.name = name;
        return this;
    }

    public MyReceiver<T> reset() {
        this.list.clear();
        return this;
    }

    public int size() {
        return this.list.size();
    }

    @Override
    public void close() throws IOException {
        this.reset();
    }
}

