/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.runnables;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.activemq.artemis.utils.runnables.AtomicRunnableWithDelegate;

public abstract class AtomicRunnable
implements Runnable {
    private volatile int ran;
    private static final AtomicIntegerFieldUpdater<AtomicRunnable> RAN_UPDATE = AtomicIntegerFieldUpdater.newUpdater(AtomicRunnable.class, "ran");

    public static AtomicRunnable checkAtomic(Runnable run) {
        if (run instanceof AtomicRunnable) {
            return (AtomicRunnable)run;
        }
        return new AtomicRunnableWithDelegate(run);
    }

    public AtomicRunnable reset() {
        RAN_UPDATE.set(this, 0);
        return this;
    }

    public AtomicRunnable setRan() {
        RAN_UPDATE.set(this, 1);
        return this;
    }

    public boolean isRun() {
        return RAN_UPDATE.get(this) == 1;
    }

    @Override
    public void run() {
        if (RAN_UPDATE.compareAndSet(this, 0, 1)) {
            this.atomicRun();
        }
    }

    public abstract void atomicRun();
}

