/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.apache.johnzon.core;

import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.AbstractJsonFactory;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.BufferStrategy;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.JsonGeneratorImpl;

public class JsonGeneratorFactoryImpl
extends AbstractJsonFactory
implements JsonGeneratorFactory {
    public static final String GENERATOR_BUFFER_LENGTH = "org.apache.activemq.artemis.shaded.org.apache.johnzon.default-char-buffer-generator";
    public static final int DEFAULT_GENERATOR_BUFFER_LENGTH = Integer.getInteger("org.apache.activemq.artemis.shaded.org.apache.johnzon.default-char-buffer-generator", 65536);
    static final Collection<String> SUPPORTED_CONFIG_KEYS = Arrays.asList("javax.json.stream.JsonGenerator.prettyPrinting", "org.apache.activemq.artemis.shaded.org.apache.johnzon.default-char-buffer-generator", "org.apache.activemq.artemis.shaded.org.apache.johnzon.buffer-strategy");
    private final ConcurrentMap<String, String> cache = null;
    private final boolean pretty = this.getBool("javax.json.stream.JsonGenerator.prettyPrinting", false);
    private final BufferStrategy.BufferProvider<char[]> bufferProvider;

    public JsonGeneratorFactoryImpl(Map<String, ?> config) {
        super(config, SUPPORTED_CONFIG_KEYS, null);
        int bufferSize = this.getInt(GENERATOR_BUFFER_LENGTH, DEFAULT_GENERATOR_BUFFER_LENGTH);
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("buffer length must be greater than zero");
        }
        this.bufferProvider = this.getBufferProvider().newCharProvider(bufferSize);
    }

    @Override
    public JsonGenerator createGenerator(Writer writer) {
        return new JsonGeneratorImpl(writer, this.bufferProvider, this.cache, this.pretty);
    }

    @Override
    public JsonGenerator createGenerator(OutputStream out) {
        return new JsonGeneratorImpl(out, this.bufferProvider, this.cache, this.pretty);
    }

    @Override
    public JsonGenerator createGenerator(OutputStream out, Charset charset) {
        return new JsonGeneratorImpl(out, charset, this.bufferProvider, this.cache, this.pretty);
    }

    @Override
    public Map<String, ?> getConfigInUse() {
        return Collections.unmodifiableMap(this.internalConfig);
    }
}

