/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.auth.sasl;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;

public class SaslClientCallbackHandler
implements CallbackHandler {
    private final String name;
    private final char[] password;
    private final String realm;

    public SaslClientCallbackHandler(String name, char[] password) {
        int realmSep = name != null ? name.indexOf(64) : -1;
        this.realm = realmSep < 0 ? "" : name.substring(realmSep + 1);
        this.name = realmSep < 0 ? name : name.substring(0, realmSep);
        this.password = password;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.password);
                continue;
            }
            if (callback instanceof RealmCallback) {
                ((RealmCallback)callback).setText(this.realm);
                continue;
            }
            if (!(callback instanceof NameCallback)) continue;
            ((NameCallback)callback).setName(this.name);
        }
    }
}

