/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.demos;

import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.JChannel;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.ReceiverAdapter;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class RelayDemo {
    public static void main(String[] args) throws Exception {
        String props = "udp.xml";
        String name = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            if (args[i].equals("-name")) {
                name = args[++i];
                continue;
            }
            System.out.println("RelayDemo [-props props] [-name name]");
            return;
        }
        final JChannel ch = new JChannel(props);
        if (name != null) {
            ch.setName(name);
        }
        ch.setReceiver(new ReceiverAdapter(){

            @Override
            public void receive(Message msg) {
                Address sender = msg.getSrc();
                System.out.println("<< " + msg.getObject() + " from " + sender);
                Address dst = msg.getDest();
                if (dst == null) {
                    Message rsp = new Message(msg.getSrc(), null, "this is a response");
                    try {
                        ch.send(rsp);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void viewAccepted(View new_view) {
                System.out.println(RelayDemo.print(new_view));
            }
        });
        ch.connect("RelayDemo");
        while (true) {
            String line = Util.readStringFromStdin(": ");
            ch.send(null, line);
        }
    }

    static String print(View view) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append(view.getClass().getSimpleName() + ": ").append(view.getViewId()).append(": ");
        for (Address mbr : view.getMembers()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(mbr);
        }
        return sb.toString();
    }
}

