/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.io.Closeable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import org.apache.activemq.artemis.shaded.org.jgroups.Event;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Property;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.PING;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ByteArrayDataInputStream;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ByteArrayDataOutputStream;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class BPING
extends PING
implements Runnable {
    @Property(description="Target address for broadcasts. This should be restricted to the local subnet, e.g. 192.168.1.255")
    protected String dest = "255.255.255.255";
    @Property(description="Port for discovery packets", systemProperty={"jgroups.bping.bind_port"})
    protected int bind_port = 8555;
    @Property(description="Sends discovery packets to ports 8555 to (8555+port_range)")
    protected int port_range = 5;
    protected DatagramSocket sock = null;
    protected volatile Thread receiver = null;
    protected InetAddress dest_addr;

    public int getBindPort() {
        return this.bind_port;
    }

    public void setBindPort(int bind_port) {
        this.bind_port = bind_port;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.dest_addr = InetAddress.getByName(this.dest);
        if (this.log.isDebugEnabled()) {
            this.log.debug("listening on " + this.bind_port);
        }
    }

    @Override
    public void start() throws Exception {
        for (int i = this.bind_port; i <= this.bind_port + this.port_range; ++i) {
            try {
                this.sock = this.getSocketFactory().createDatagramSocket("jgroups.bping.sock", i);
                break;
            }
            catch (Throwable t) {
                if (i <= this.bind_port + this.port_range) continue;
                throw new RuntimeException("failed to open a port in range [" + this.bind_port + " - " + (this.bind_port + this.port_range) + "]", t);
            }
        }
        this.sock.setBroadcast(true);
        this.startReceiver();
        super.start();
    }

    private void startReceiver() {
        if (this.receiver == null || !this.receiver.isAlive()) {
            this.receiver = new Thread((Runnable)this, "ReceiverThread");
            this.receiver.setDaemon(true);
            this.receiver.start();
            if (this.log.isTraceEnabled()) {
                this.log.trace("receiver thread started");
            }
        }
    }

    @Override
    public void stop() {
        Util.close((Closeable)this.sock);
        this.sock = null;
        this.receiver = null;
        super.stop();
    }

    @Override
    protected void sendMcastDiscoveryRequest(Message msg) {
        try {
            if (msg.getSrc() == null) {
                msg.setSrc(this.local_addr);
            }
            ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(128);
            msg.writeTo(out);
            for (int i = this.bind_port; i <= this.bind_port + this.port_range; ++i) {
                DatagramPacket packet = new DatagramPacket(out.buffer(), 0, out.position(), this.dest_addr, i);
                this.sock.send(packet);
            }
        }
        catch (Exception ex) {
            this.log.error(Util.getMessage("FailedSendingDiscoveryRequest"), ex);
        }
    }

    @Override
    public void run() {
        byte[] receive_buf = new byte[65535];
        DatagramPacket packet = new DatagramPacket(receive_buf, receive_buf.length);
        while (this.sock != null && this.receiver != null && Thread.currentThread().equals(this.receiver)) {
            packet.setData(receive_buf, 0, receive_buf.length);
            try {
                this.sock.receive(packet);
                ByteArrayDataInputStream inp = new ByteArrayDataInputStream(packet.getData(), packet.getOffset(), packet.getLength());
                Message msg = new Message();
                msg.readFrom(inp);
                this.up(new Event(1, msg));
            }
            catch (SocketException socketEx) {
                break;
            }
            catch (Throwable ex) {
                this.log.error(Util.getMessage("FailedReceivingPacketFrom"), packet.getSocketAddress(), ex);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("receiver thread terminated");
        }
    }
}

