/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.util.Collection;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.PhysicalAddress;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedAttribute;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedOperation;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs.TcpServer;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.BasicTCP;
import org.apache.activemq.artemis.shaded.org.jgroups.util.SocketFactory;

public class TCP
extends BasicTCP {
    private TcpServer server = null;

    @ManagedAttribute
    public int getOpenConnections() {
        return this.server.getNumConnections();
    }

    @Override
    @ManagedOperation
    public String printConnections() {
        return this.server.printConnections();
    }

    @ManagedOperation(description="Clears all connections (they will get re-established). For testing only, don't use !")
    public void clearConnections() {
        this.server.clearConnections();
    }

    @Override
    public void setSocketFactory(SocketFactory factory) {
        super.setSocketFactory(factory);
        if (this.server != null) {
            this.server.socketFactory(factory);
        }
    }

    @Override
    public void send(Address dest, byte[] data, int offset, int length) throws Exception {
        if (this.server != null) {
            this.server.send(dest, data, offset, length);
        }
    }

    @Override
    public void retainAll(Collection<Address> members) {
        this.server.retainAll(members);
    }

    @Override
    public void start() throws Exception {
        this.server = (TcpServer)((TcpServer)new TcpServer(this.getThreadFactory(), this.getSocketFactory(), this.bind_addr, this.bind_port, this.bind_port + this.port_range, this.external_addr, this.external_port).receiver(this).timeService(this.time_service).receiveBufferSize(this.recv_buf_size).sendBufferSize(this.send_buf_size).socketConnectionTimeout(this.sock_conn_timeout).tcpNodelay(this.tcp_nodelay).linger(this.linger).clientBindAddress(this.client_bind_addr).clientBindPort(this.client_bind_port).deferClientBinding(this.defer_client_bind_addr).log(this.log)).socketFactory(this.getSocketFactory()).peerAddressReadTimeout(this.peer_addr_read_timeout).useSendQueues(this.use_send_queues).sendQueueSize(this.send_queue_size).usePeerConnections(true);
        if (this.reaper_interval > 0L || this.conn_expire_time > 0L) {
            if (this.reaper_interval == 0L) {
                this.reaper_interval = 5000L;
                this.log.warn("reaper_interval was 0, set it to %d", this.reaper_interval);
            }
            if (this.conn_expire_time == 0L) {
                this.conn_expire_time = 300000L;
                this.log.warn("conn_expire_time was 0, set it to %d", this.conn_expire_time);
            }
            this.server.connExpireTimeout(this.conn_expire_time).reaperInterval(this.reaper_interval);
        }
        super.start();
    }

    @Override
    public void stop() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("closing sockets and stopping threads");
        }
        this.server.stop();
        super.stop();
    }

    @Override
    protected void handleConnect() throws Exception {
        if (this.isSingleton()) {
            if (this.connect_count == 0) {
                this.server.start();
            }
            super.handleConnect();
        } else {
            this.server.start();
        }
    }

    @Override
    protected void handleDisconnect() {
        if (this.isSingleton()) {
            super.handleDisconnect();
            if (this.connect_count == 0) {
                this.server.stop();
            }
        } else {
            this.server.stop();
        }
    }

    @Override
    protected PhysicalAddress getPhysicalAddress() {
        return this.server != null ? (PhysicalAddress)this.server.localAddress() : null;
    }
}

