/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols.tom;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Bits;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Streamable;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class MessageID
implements Externalizable,
Comparable<MessageID>,
Cloneable,
Streamable {
    private static final long serialVersionUID = 878801547232534461L;
    private Address address = null;
    private long id = -1L;

    public MessageID() {
    }

    public MessageID(Address address, long id) {
        this.address = address;
        this.id = id;
    }

    @Override
    public int compareTo(MessageID other) {
        if (other == null) {
            throw new NullPointerException();
        }
        return this.id == other.id ? this.address.compareTo(other.address) : (this.id < other.id ? -1 : 1);
    }

    public Address getAddress() {
        return this.address;
    }

    public String toString() {
        return "MessageID{" + this.address + ":" + this.id + "}";
    }

    public Object clone() {
        try {
            MessageID dolly = (MessageID)super.clone();
            dolly.address = this.address;
            return dolly;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageID messageID = (MessageID)o;
        return this.id == messageID.id && !(this.address == null ? messageID.address != null : !this.address.equals(messageID.address));
    }

    public int hashCode() {
        int result = this.address != null ? this.address.hashCode() : 0;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public int serializedSize() {
        return Bits.size(this.id) + Util.size(this.address);
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        Util.writeAddress(this.address, out);
        Bits.writeLong(this.id, out);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        this.address = Util.readAddress(in);
        this.id = Bits.readLong(in);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        try {
            this.writeTo(objectOutput);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        try {
            this.readFrom(objectInput);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

