/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.protocol;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.core.remoting.CloseListener;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.shaded.org.jboss.logging.Logger;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;

public abstract class AbstractRemotingConnection
implements RemotingConnection {
    private static final Logger logger = Logger.getLogger(AbstractRemotingConnection.class);
    protected final List<FailureListener> failureListeners = new CopyOnWriteArrayList<FailureListener>();
    protected final List<CloseListener> closeListeners = new CopyOnWriteArrayList<CloseListener>();
    protected final Connection transportConnection;
    protected final Executor executor;
    protected final long creationTime;
    protected volatile boolean dataReceived;
    private String clientId;

    public AbstractRemotingConnection(Connection transportConnection, Executor executor) {
        this.transportConnection = transportConnection;
        this.executor = executor;
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    public void scheduledFlush() {
        this.flush();
    }

    @Override
    public List<FailureListener> getFailureListeners() {
        return new ArrayList<FailureListener>(this.failureListeners);
    }

    @Override
    public boolean isWritable(ReadyListener callback) {
        return this.transportConnection.isWritable(callback);
    }

    protected void callFailureListeners(ActiveMQException me, String scaleDownTargetNodeID) {
        ArrayList<FailureListener> listenersClone = new ArrayList<FailureListener>(this.failureListeners);
        for (FailureListener listener : listenersClone) {
            try {
                listener.connectionFailed(me, false, scaleDownTargetNodeID);
            }
            catch (ActiveMQInterruptedException interrupted) {
                logger.debug((Object)"thread interrupted", interrupted);
            }
            catch (Throwable t) {
                ActiveMQClientLogger.LOGGER.errorCallingFailureListener(t);
            }
        }
    }

    protected void callClosingListeners() {
        ArrayList<CloseListener> listenersClone = new ArrayList<CloseListener>(this.closeListeners);
        for (CloseListener listener : listenersClone) {
            try {
                listener.connectionClosed();
            }
            catch (Throwable t) {
                ActiveMQClientLogger.LOGGER.errorCallingFailureListener(t);
            }
        }
    }

    @Override
    public void setFailureListeners(List<FailureListener> listeners) {
        this.failureListeners.clear();
        this.failureListeners.addAll(listeners);
    }

    @Override
    public Object getID() {
        return this.transportConnection.getID();
    }

    public String getLocalAddress() {
        return this.transportConnection.getLocalAddress();
    }

    @Override
    public String getRemoteAddress() {
        return this.transportConnection.getRemoteAddress();
    }

    @Override
    public void addFailureListener(FailureListener listener) {
        if (listener == null) {
            throw ActiveMQClientMessageBundle.BUNDLE.failListenerCannotBeNull();
        }
        this.failureListeners.add(listener);
    }

    @Override
    public boolean removeFailureListener(FailureListener listener) {
        if (listener == null) {
            throw ActiveMQClientMessageBundle.BUNDLE.failListenerCannotBeNull();
        }
        return this.failureListeners.remove(listener);
    }

    @Override
    public void addCloseListener(CloseListener listener) {
        if (listener == null) {
            throw ActiveMQClientMessageBundle.BUNDLE.closeListenerCannotBeNull();
        }
        this.closeListeners.add(listener);
    }

    @Override
    public boolean removeCloseListener(CloseListener listener) {
        if (listener == null) {
            throw ActiveMQClientMessageBundle.BUNDLE.closeListenerCannotBeNull();
        }
        return this.closeListeners.remove(listener);
    }

    @Override
    public List<CloseListener> removeCloseListeners() {
        ArrayList<CloseListener> ret = new ArrayList<CloseListener>(this.closeListeners);
        this.closeListeners.clear();
        return ret;
    }

    @Override
    public List<FailureListener> removeFailureListeners() {
        List<FailureListener> ret = this.getFailureListeners();
        this.failureListeners.clear();
        return ret;
    }

    @Override
    public void setCloseListeners(List<CloseListener> listeners) {
        this.closeListeners.clear();
        this.closeListeners.addAll(listeners);
    }

    @Override
    public ActiveMQBuffer createTransportBuffer(int size) {
        return this.transportConnection.createTransportBuffer(size);
    }

    @Override
    public Connection getTransportConnection() {
        return this.transportConnection;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public boolean checkDataReceived() {
        boolean res = this.dataReceived;
        this.dataReceived = false;
        return res;
    }

    @Override
    public boolean isSupportReconnect() {
        return false;
    }

    @Override
    public void fail(ActiveMQException me) {
        this.fail(me, null);
    }

    @Override
    public void bufferReceived(Object connectionID, ActiveMQBuffer buffer) {
        this.dataReceived = true;
    }

    @Override
    public boolean isSupportsFlowControl() {
        return true;
    }

    @Override
    public Subject getSubject() {
        return null;
    }

    @Override
    public void setClientID(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public String getClientID() {
        return this.clientId;
    }
}

