/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.shaded.org.jboss.logging.Logger;

public class SpawnedVMSupport {
    static ConcurrentHashMap<Process, String> startedProcesses = null;
    private static final Logger log = Logger.getLogger(SpawnedVMSupport.class);

    public static Process spawnVM(String className, String ... args) throws Exception {
        return SpawnedVMSupport.spawnVM(className, new String[0], true, args);
    }

    public static Process spawnVM(String className, boolean logOutput, String ... args) throws Exception {
        return SpawnedVMSupport.spawnVM(className, new String[0], logOutput, args);
    }

    public static Process spawnVM(String classPath, String className, boolean logOutput, String ... args) throws Exception {
        return SpawnedVMSupport.spawnVM(classPath, className, new String[0], logOutput, args);
    }

    public static Process spawnVM(String className, String[] vmargs, String ... args) throws Exception {
        return SpawnedVMSupport.spawnVM(className, vmargs, true, args);
    }

    public static Process spawnVM(String className, String[] vmargs, boolean logOutput, String ... args) throws Exception {
        return SpawnedVMSupport.spawnVM(className, "-Xms512m", "-Xmx512m", vmargs, logOutput, true, true, args);
    }

    public static Process spawnVM(String classpath, String className, String[] vmargs, boolean logOutput, String ... args) throws Exception {
        return SpawnedVMSupport.spawnVM(classpath, className, "-Xms512m", "-Xmx512m", vmargs, logOutput, true, true, args);
    }

    public static Process spawnVMWithLogMacher(String wordMatch, Runnable runnable, String className, String[] vmargs, boolean logOutput, String ... args) throws Exception {
        return SpawnedVMSupport.spawnVM(wordMatch, runnable, className, "-Xms512m", "-Xmx512m", vmargs, logOutput, true, true, args);
    }

    public static Process spawnVM(String className, String memoryArg1, String memoryArg2, String[] vmargs, boolean logOutput, boolean logErrorOutput, boolean useLogging, String ... args) throws Exception {
        return SpawnedVMSupport.spawnVM(null, null, className, memoryArg1, memoryArg2, vmargs, logOutput, logErrorOutput, useLogging, args);
    }

    public static Process spawnVM(String classPath, String className, String memoryArg1, String memoryArg2, String[] vmargs, boolean logOutput, boolean logErrorOutput, boolean useLogging, String ... args) throws Exception {
        return SpawnedVMSupport.spawnVM(classPath, null, null, className, memoryArg1, memoryArg2, vmargs, logOutput, logErrorOutput, useLogging, args);
    }

    public static Process spawnVM(String wordMatch, Runnable wordRunning, String className, String memoryArg1, String memoryArg2, String[] vmargs, boolean logOutput, boolean logErrorOutput, boolean useLogging, String ... args) throws Exception {
        return SpawnedVMSupport.spawnVM(SpawnedVMSupport.getClassPath(), wordMatch, wordRunning, className, memoryArg1, memoryArg2, vmargs, logOutput, logErrorOutput, useLogging, args);
    }

    public static Process spawnVM(String classPath, String wordMatch, Runnable wordRunning, String className, String memoryArg1, String memoryArg2, String[] vmargs, boolean logOutput, boolean logErrorOutput, boolean useLogging, String ... args) throws IOException, ClassNotFoundException {
        return SpawnedVMSupport.spawnVM(classPath, wordMatch, wordRunning, className, memoryArg1, memoryArg2, vmargs, logOutput, logErrorOutput, useLogging, -1L, args);
    }

    public static String getClassPath() {
        return System.getProperty("java.class.path");
    }

    public static String getClassPath(File libfolder) {
        if (libfolder == null) {
            return SpawnedVMSupport.getClassPath();
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean empty = true;
        File[] files = libfolder.listFiles();
        if (files == null) {
            return SpawnedVMSupport.getClassPath();
        }
        for (File f : files) {
            if (!f.getName().endsWith(".jar") && !f.getName().endsWith(".zip")) continue;
            if (!empty) {
                stringBuilder.append(File.pathSeparator);
            }
            empty = false;
            stringBuilder.append(f.toString());
        }
        return stringBuilder.toString();
    }

    public static Process spawnVM(String classPath, String wordMatch, Runnable wordRunning, String className, String memoryArg1, String memoryArg2, String[] vmargs, boolean logOutput, boolean logErrorOutput, boolean useLogging, long debugPort, String ... args) throws IOException, ClassNotFoundException {
        String loggingPlugin;
        String jacocoAgent;
        String javaPath = Paths.get(System.getProperty("java.home"), "bin", "java").toAbsolutePath().toString();
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        if (memoryArg1 == null) {
            memoryArg1 = "-Xms128m";
        }
        if (memoryArg2 == null) {
            memoryArg2 = "-Xmx128m";
        }
        builder.command(javaPath, memoryArg1, memoryArg2);
        if (debugPort > 0L) {
            builder.command().add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=" + debugPort);
        }
        builder.environment().put("CLASSPATH", classPath);
        List<String> commandList = builder.command();
        if (vmargs != null) {
            for (String string : vmargs) {
                commandList.add(string);
            }
        }
        if (useLogging) {
            commandList.add("-Djava.util.logging.manager=org.jboss.logmanager.LogManager");
            commandList.add("-Dlogging.configuration=file:../config/logging.properties");
        }
        commandList.add("-Djava.io.tmpdir=" + System.getProperty("java.io.tmpdir", "./tmp"));
        commandList.add("-Djava.library.path=" + System.getProperty("java.library.path", "./native/bin"));
        String loggingConfigFile = System.getProperty("java.util.logging.config.file");
        if (loggingConfigFile != null) {
            commandList.add("-Djava.util.logging.config.file=" + loggingConfigFile + " ");
        }
        if ((jacocoAgent = System.getProperty("jacoco.agent")) != null && !jacocoAgent.isEmpty()) {
            commandList.add(jacocoAgent);
        }
        if ((loggingPlugin = System.getProperty("org.apache.activemq.artemis.shaded.org.jboss.logging.Logger.pluginClass")) != null) {
            commandList.add("-Dorg.jboss.logging.Logger.pluginClass=" + loggingPlugin + " ");
        }
        commandList.add(className);
        for (String arg : args) {
            commandList.add(arg);
        }
        Process process = builder.start();
        SpawnedVMSupport.startLogger(logOutput, wordMatch, wordRunning, className, process);
        ProcessLogger errorLogger = new ProcessLogger(logErrorOutput, process.getErrorStream(), className, wordMatch, wordRunning);
        errorLogger.start();
        if (startedProcesses != null) {
            startedProcesses.put(process, className);
        }
        return process;
    }

    private static HashSet<Process> getAliveProcesses() {
        HashSet<Process> aliveProcess = new HashSet<Process>();
        if (startedProcesses != null) {
            while (true) {
                try {
                    aliveProcess.clear();
                    for (Process process : startedProcesses.keySet()) {
                        if (!process.isAlive()) continue;
                        aliveProcess.add(process);
                        process.destroyForcibly();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
        return aliveProcess;
    }

    public static void forceKill() {
        HashSet<Process> aliveProcess = SpawnedVMSupport.getAliveProcesses();
        for (Process alive : aliveProcess) {
            for (int i = 0; i < 5; ++i) {
                alive.destroyForcibly();
                try {
                    alive.waitFor(5L, TimeUnit.SECONDS);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void enableCheck() {
        startedProcesses = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkProcess() {
        HashSet<Process> aliveProcess = SpawnedVMSupport.getAliveProcesses();
        try {
            if (!aliveProcess.isEmpty()) {
                StringBuffer buffer = new StringBuffer();
                for (Process alive : aliveProcess) {
                    alive.destroyForcibly();
                    buffer.append(startedProcesses.get(alive) + " ");
                }
                boolean bl = false;
                return bl;
            }
        }
        finally {
            startedProcesses = null;
        }
        return true;
    }

    public static void startLogger(boolean print, String wordMatch, Runnable wordRunanble, String className, Process process) throws ClassNotFoundException {
        ProcessLogger outputLogger = new ProcessLogger(print, process.getInputStream(), className, wordMatch, wordRunanble);
        outputLogger.start();
    }

    public static void startLogger(String className, Process process) throws ClassNotFoundException {
        SpawnedVMSupport.startLogger(true, null, null, className, process);
    }

    static class ProcessLogger
    extends Thread {
        private final InputStream is;
        private final String className;
        private final boolean print;
        private final String wordMatch;
        private final Runnable wordRunner;

        ProcessLogger(boolean print, InputStream is, String className, String wordMatch, Runnable wordRunner) throws ClassNotFoundException {
            this.is = is;
            this.print = print;
            this.className = className;
            this.wordMatch = wordMatch;
            this.wordRunner = wordRunner;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (this.wordMatch != null && this.wordRunner != null && line.contains(this.wordMatch)) {
                        this.wordRunner.run();
                    }
                    if (!this.print) continue;
                    System.out.println(this.className + ":" + line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

