/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.TransactionRolledBackException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;

public final class JMSExceptionHelper {
    public static JMSException convertFromActiveMQException(ActiveMQInterruptedException me) {
        IllegalStateException je = new IllegalStateException(me.getMessage());
        je.setStackTrace(me.getStackTrace());
        je.initCause((Throwable)me);
        return je;
    }

    public static JMSException convertFromActiveMQException(ActiveMQException me) {
        Throwable je;
        switch (me.getType()) {
            case CONNECTION_TIMEDOUT: 
            case INTERNAL_ERROR: 
            case NOT_CONNECTED: {
                je = new JMSException(me.getMessage());
                break;
            }
            case UNSUPPORTED_PACKET: 
            case OBJECT_CLOSED: 
            case ILLEGAL_STATE: {
                je = new IllegalStateException(me.getMessage());
                break;
            }
            case QUEUE_DOES_NOT_EXIST: 
            case QUEUE_EXISTS: {
                je = new InvalidDestinationException(me.getMessage());
                break;
            }
            case INVALID_FILTER_EXPRESSION: {
                je = new InvalidSelectorException(me.getMessage());
                break;
            }
            case SECURITY_EXCEPTION: {
                je = new JMSSecurityException(me.getMessage());
                break;
            }
            case TRANSACTION_ROLLED_BACK: {
                je = new TransactionRolledBackException(me.getMessage());
                break;
            }
            default: {
                je = new JMSException(me.getMessage());
            }
        }
        je.setStackTrace(me.getStackTrace());
        je.initCause((Throwable)me);
        return je;
    }
}

