/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public final class UnpooledUnsafeDirectByteBufWrapper
extends AbstractReferenceCountedByteBuf {
    private ByteBuffer buffer = null;
    private long memoryAddress = 0L;

    public UnpooledUnsafeDirectByteBufWrapper() {
        super(0);
    }

    public void wrap(ByteBuffer buffer, int srcIndex, int length) {
        if (buffer != null) {
            this.buffer = buffer;
            this.memoryAddress = PlatformDependent.directBufferAddress((ByteBuffer)buffer) + (long)srcIndex;
            this.clear();
            this.maxCapacity(length);
        } else {
            this.reset();
        }
    }

    public void reset() {
        this.buffer = null;
        this.memoryAddress = 0L;
        this.clear();
        this.maxCapacity(0);
    }

    public boolean isDirect() {
        return true;
    }

    public int capacity() {
        return this.maxCapacity();
    }

    public ByteBuf capacity(int newCapacity) {
        if (newCapacity != this.maxCapacity()) {
            throw new IllegalArgumentException("can't set a capacity different from the max allowed one");
        }
        return this;
    }

    public ByteBufAllocator alloc() {
        return null;
    }

    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    public boolean hasArray() {
        return false;
    }

    public byte[] array() {
        throw new UnsupportedOperationException("direct buffer");
    }

    public int arrayOffset() {
        throw new UnsupportedOperationException("direct buffer");
    }

    public boolean hasMemoryAddress() {
        return true;
    }

    public long memoryAddress() {
        return this.memoryAddress;
    }

    protected byte _getByte(int index) {
        return UnsafeByteBufUtil.getByte((long)this.addr(index));
    }

    protected short _getShort(int index) {
        return UnsafeByteBufUtil.getShort((long)this.addr(index));
    }

    protected short _getShortLE(int index) {
        return UnsafeByteBufUtil.getShortLE((long)this.addr(index));
    }

    protected int _getUnsignedMedium(int index) {
        return UnsafeByteBufUtil.getUnsignedMedium((long)this.addr(index));
    }

    protected int _getUnsignedMediumLE(int index) {
        return UnsafeByteBufUtil.getUnsignedMediumLE((long)this.addr(index));
    }

    protected int _getInt(int index) {
        return UnsafeByteBufUtil.getInt((long)this.addr(index));
    }

    protected int _getIntLE(int index) {
        return UnsafeByteBufUtil.getIntLE((long)this.addr(index));
    }

    protected long _getLong(int index) {
        return UnsafeByteBufUtil.getLong((long)this.addr(index));
    }

    protected long _getLongLE(int index) {
        return UnsafeByteBufUtil.getLongLE((long)this.addr(index));
    }

    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)this, (long)this.addr(index), (int)index, (ByteBuf)dst, (int)dstIndex, (int)length);
        return this;
    }

    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)this, (long)this.addr(index), (int)index, (byte[])dst, (int)dstIndex, (int)length);
        return this;
    }

    public ByteBuf getBytes(int index, ByteBuffer dst) {
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)this, (long)this.addr(index), (int)index, (ByteBuffer)dst);
        return this;
    }

    public ByteBuf readBytes(ByteBuffer dst) {
        int length = dst.remaining();
        this.checkReadableBytes(length);
        this.getBytes(this.readerIndex, dst);
        this.readerIndex += length;
        return this;
    }

    protected void _setByte(int index, int value) {
        UnsafeByteBufUtil.setByte((long)this.addr(index), (int)value);
    }

    protected void _setShort(int index, int value) {
        UnsafeByteBufUtil.setShort((long)this.addr(index), (int)value);
    }

    protected void _setShortLE(int index, int value) {
        UnsafeByteBufUtil.setShortLE((long)this.addr(index), (int)value);
    }

    protected void _setMedium(int index, int value) {
        UnsafeByteBufUtil.setMedium((long)this.addr(index), (int)value);
    }

    protected void _setMediumLE(int index, int value) {
        UnsafeByteBufUtil.setMediumLE((long)this.addr(index), (int)value);
    }

    protected void _setInt(int index, int value) {
        UnsafeByteBufUtil.setInt((long)this.addr(index), (int)value);
    }

    protected void _setIntLE(int index, int value) {
        UnsafeByteBufUtil.setIntLE((long)this.addr(index), (int)value);
    }

    protected void _setLong(int index, long value) {
        UnsafeByteBufUtil.setLong((long)this.addr(index), (long)value);
    }

    protected void _setLongLE(int index, long value) {
        UnsafeByteBufUtil.setLongLE((long)this.addr(index), (long)value);
    }

    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)this, (long)this.addr(index), (int)index, (ByteBuf)src, (int)srcIndex, (int)length);
        return this;
    }

    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)this, (long)this.addr(index), (int)index, (byte[])src, (int)srcIndex, (int)length);
        return this;
    }

    public ByteBuf setBytes(int index, ByteBuffer src) {
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)this, (long)this.addr(index), (int)index, (ByteBuffer)src);
        return this;
    }

    @Deprecated
    public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        throw new UnsupportedOperationException("unsupported!");
    }

    @Deprecated
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        throw new UnsupportedOperationException("unsupported!");
    }

    @Deprecated
    public int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        throw new UnsupportedOperationException("unsupported!");
    }

    @Deprecated
    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        throw new UnsupportedOperationException("unsupported!");
    }

    @Deprecated
    public int readBytes(FileChannel out, long position, int length) throws IOException {
        throw new UnsupportedOperationException("unsupported!");
    }

    @Deprecated
    public int setBytes(int index, InputStream in, int length) throws IOException {
        throw new UnsupportedOperationException("unsupported!");
    }

    @Deprecated
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        throw new UnsupportedOperationException("unsupported!");
    }

    @Deprecated
    public int setBytes(int index, FileChannel in, long position, int length) throws IOException {
        throw new UnsupportedOperationException("unsupported!");
    }

    public int nioBufferCount() {
        return 1;
    }

    @Deprecated
    public ByteBuffer[] nioBuffers(int index, int length) {
        throw new UnsupportedOperationException("unsupported!");
    }

    @Deprecated
    public ByteBuf copy(int index, int length) {
        throw new UnsupportedOperationException("unsupported!");
    }

    @Deprecated
    public ByteBuffer internalNioBuffer(int index, int length) {
        throw new UnsupportedOperationException("cannot access directly the wrapped buffer!");
    }

    @Deprecated
    public ByteBuffer nioBuffer(int index, int length) {
        throw new UnsupportedOperationException("unsupported!");
    }

    @Deprecated
    protected void deallocate() {
    }

    public ByteBuf unwrap() {
        return null;
    }

    private long addr(int index) {
        return this.memoryAddress + (long)index;
    }

    @Deprecated
    protected SwappedByteBuf newSwappedByteBuf() {
        throw new UnsupportedOperationException("unsupported!");
    }

    public ByteBuf setZero(int index, int length) {
        UnsafeByteBufUtil.setZero((AbstractByteBuf)this, (long)this.addr(index), (int)index, (int)length);
        return this;
    }

    public ByteBuf writeZero(int length) {
        this.ensureWritable(length);
        int wIndex = this.writerIndex;
        this.setZero(wIndex, length);
        this.writerIndex = wIndex + length;
        return this;
    }
}

