/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTConnection;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTLogger;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSession;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;

public class MQTTSessionCallback
implements SessionCallback {
    private final MQTTSession session;
    private final MQTTConnection connection;

    public MQTTSessionCallback(MQTTSession session, MQTTConnection connection) throws Exception {
        this.session = session;
        this.connection = connection;
    }

    public boolean supportsDirectDelivery() {
        return false;
    }

    public boolean isWritable(ReadyListener callback, Object protocolContext) {
        return this.connection.isWritable(callback);
    }

    public int sendMessage(MessageReference reference, Message message, ServerConsumer consumer, int deliveryCount) {
        try {
            this.session.getMqttPublishManager().sendMessage(message.toCore(), consumer, deliveryCount);
        }
        catch (Exception e) {
            MQTTLogger.LOGGER.unableToSendMessage(reference, e);
        }
        return 1;
    }

    public boolean updateDeliveryCountAfterCancel(ServerConsumer consumer, MessageReference ref, boolean failed) {
        return false;
    }

    public int sendLargeMessageContinuation(ServerConsumer consumerID, byte[] body, boolean continues, boolean requiresResponse) {
        return 1;
    }

    public int sendLargeMessage(MessageReference reference, Message message, ServerConsumer consumer, long bodySize, int deliveryCount) {
        return this.sendMessage(reference, message, consumer, deliveryCount);
    }

    public void disconnect(ServerConsumer consumer, SimpleString queueName) {
        try {
            consumer.removeItself();
        }
        catch (Exception e) {
            MQTTLogger.LOGGER.errorDisconnectingConsumer(e);
        }
    }

    public void afterDelivery() throws Exception {
    }

    public void browserFinished(ServerConsumer consumer) {
    }

    public boolean hasCredits(ServerConsumer consumerID) {
        return this.hasCredits(consumerID, null);
    }

    public boolean hasCredits(ServerConsumer consumerID, MessageReference ref) {
        return ref == null || !ref.isDurable() || this.connection.getReceiveMaximum() == -1 || this.session.getState().getOutboundStore().getPendingMessages() < this.connection.getReceiveMaximum();
    }

    public void sendProducerCreditsMessage(int credits, SimpleString address) {
    }

    public void sendProducerCreditsFailMessage(int credits, SimpleString address) {
    }

    public void closed() {
    }
}

