/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.openwire;

import java.util.Map;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireConnection;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireProtocolManager;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireRedirectContext;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.balancing.RedirectHandler;
import org.apache.activemq.artemis.utils.ConfigurationHelper;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionControl;
import org.apache.activemq.command.ConnectionInfo;

public class OpenWireRedirectHandler
extends RedirectHandler<OpenWireRedirectContext> {
    private final OpenWireProtocolManager protocolManager;

    protected OpenWireRedirectHandler(ActiveMQServer server, OpenWireProtocolManager protocolManager) {
        super(server);
        this.protocolManager = protocolManager;
    }

    public boolean redirect(OpenWireConnection openWireConnection, ConnectionInfo connectionInfo) throws Exception {
        if (!connectionInfo.isFaultTolerant()) {
            throw new IllegalStateException("Client not fault tolerant");
        }
        return this.redirect(new OpenWireRedirectContext(openWireConnection, connectionInfo));
    }

    protected void cannotRedirect(OpenWireRedirectContext context) throws Exception {
    }

    protected void redirectTo(OpenWireRedirectContext context) throws Exception {
        String host = ConfigurationHelper.getStringProperty((String)"host", (String)"localhost", (Map)context.getTarget().getConnector().getParams());
        int port = ConfigurationHelper.getIntProperty((String)"port", (int)61616, (Map)context.getTarget().getConnector().getParams());
        ConnectionControl command = this.protocolManager.newConnectionControl();
        command.setConnectedBrokers(String.format("tcp://%s:%d", host, port));
        command.setRebalanceConnection(true);
        context.getOpenWireConnection().dispatchSync((Command)command);
    }
}

