/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.activemq.artemis.ra.ActiveMQRASession;
import org.apache.activemq.artemis.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQRAMessage
implements Message {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected Message message;
    protected ActiveMQRASession session;

    public ActiveMQRAMessage(Message message, ActiveMQRASession session) {
        Preconditions.checkNotNull((Object)message);
        Preconditions.checkNotNull((Object)session);
        logger.trace("constructor({}, {})", (Object)message, (Object)session);
        this.message = message;
        this.session = session;
    }

    public void acknowledge() throws JMSException {
        logger.trace("acknowledge()");
        this.session.getSession();
        this.message.acknowledge();
    }

    public void clearBody() throws JMSException {
        logger.trace("clearBody()");
        this.message.clearBody();
    }

    public void clearProperties() throws JMSException {
        logger.trace("clearProperties()");
        this.message.clearProperties();
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        logger.trace("getBooleanProperty({})", (Object)name);
        return this.message.getBooleanProperty(name);
    }

    public byte getByteProperty(String name) throws JMSException {
        logger.trace("getByteProperty({})", (Object)name);
        return this.message.getByteProperty(name);
    }

    public double getDoubleProperty(String name) throws JMSException {
        logger.trace("getDoubleProperty({})", (Object)name);
        return this.message.getDoubleProperty(name);
    }

    public float getFloatProperty(String name) throws JMSException {
        logger.trace("getFloatProperty({})", (Object)name);
        return this.message.getFloatProperty(name);
    }

    public int getIntProperty(String name) throws JMSException {
        logger.trace("getIntProperty({})", (Object)name);
        return this.message.getIntProperty(name);
    }

    public String getJMSCorrelationID() throws JMSException {
        logger.trace("getJMSCorrelationID()");
        return this.message.getJMSCorrelationID();
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        logger.trace("getJMSCorrelationIDAsBytes()");
        return this.message.getJMSCorrelationIDAsBytes();
    }

    public int getJMSDeliveryMode() throws JMSException {
        logger.trace("getJMSDeliveryMode()");
        return this.message.getJMSDeliveryMode();
    }

    public Destination getJMSDestination() throws JMSException {
        logger.trace("getJMSDestination()");
        return this.message.getJMSDestination();
    }

    public long getJMSExpiration() throws JMSException {
        logger.trace("getJMSExpiration()");
        return this.message.getJMSExpiration();
    }

    public String getJMSMessageID() throws JMSException {
        logger.trace("getJMSMessageID()");
        return this.message.getJMSMessageID();
    }

    public int getJMSPriority() throws JMSException {
        logger.trace("getJMSPriority()");
        return this.message.getJMSPriority();
    }

    public boolean getJMSRedelivered() throws JMSException {
        logger.trace("getJMSRedelivered()");
        return this.message.getJMSRedelivered();
    }

    public Destination getJMSReplyTo() throws JMSException {
        logger.trace("getJMSReplyTo()");
        return this.message.getJMSReplyTo();
    }

    public long getJMSTimestamp() throws JMSException {
        logger.trace("getJMSTimestamp()");
        return this.message.getJMSTimestamp();
    }

    public String getJMSType() throws JMSException {
        logger.trace("getJMSType()");
        return this.message.getJMSType();
    }

    public long getLongProperty(String name) throws JMSException {
        logger.trace("getLongProperty({})", (Object)name);
        return this.message.getLongProperty(name);
    }

    public Object getObjectProperty(String name) throws JMSException {
        logger.trace("getObjectProperty({})", (Object)name);
        return this.message.getObjectProperty(name);
    }

    public Enumeration getPropertyNames() throws JMSException {
        logger.trace("getPropertyNames()");
        return this.message.getPropertyNames();
    }

    public short getShortProperty(String name) throws JMSException {
        logger.trace("getShortProperty({})", (Object)name);
        return this.message.getShortProperty(name);
    }

    public String getStringProperty(String name) throws JMSException {
        logger.trace("getStringProperty({})", (Object)name);
        return this.message.getStringProperty(name);
    }

    public boolean propertyExists(String name) throws JMSException {
        logger.trace("propertyExists({})", (Object)name);
        return this.message.propertyExists(name);
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setBooleanProperty({}, {})", (Object)name, (Object)value);
        }
        this.message.setBooleanProperty(name, value);
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setByteProperty({}, {})", (Object)name, (Object)value);
        }
        this.message.setByteProperty(name, value);
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setDoubleProperty({}, {})", (Object)name, (Object)value);
        }
        this.message.setDoubleProperty(name, value);
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setFloatProperty({}, {})", (Object)name, (Object)Float.valueOf(value));
        }
        this.message.setFloatProperty(name, value);
    }

    public void setIntProperty(String name, int value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setIntProperty({}, {})", (Object)name, (Object)value);
        }
        this.message.setIntProperty(name, value);
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setJMSCorrelationID({})", (Object)correlationID);
        }
        this.message.setJMSCorrelationID(correlationID);
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setJMSCorrelationIDAsBytes({})", (Object)Arrays.toString(correlationID));
        }
        this.message.setJMSCorrelationIDAsBytes(correlationID);
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setJMSDeliveryMode({})", (Object)deliveryMode);
        }
        this.message.setJMSDeliveryMode(deliveryMode);
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        logger.trace("setJMSDestination({})", (Object)destination);
        this.message.setJMSDestination(destination);
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setJMSExpiration({})", (Object)expiration);
        }
        this.message.setJMSExpiration(expiration);
    }

    public void setJMSMessageID(String id) throws JMSException {
        logger.trace("setJMSMessageID({})", (Object)id);
        this.message.setJMSMessageID(id);
    }

    public void setJMSPriority(int priority) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setJMSPriority({})", (Object)priority);
        }
        this.message.setJMSPriority(priority);
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setJMSRedelivered({})", (Object)redelivered);
        }
        this.message.setJMSRedelivered(redelivered);
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        logger.trace("setJMSReplyTo({})", (Object)replyTo);
        this.message.setJMSReplyTo(replyTo);
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setJMSTimestamp({})", (Object)timestamp);
        }
        this.message.setJMSTimestamp(timestamp);
    }

    public void setJMSType(String type) throws JMSException {
        logger.trace("setJMSType({})", (Object)type);
        this.message.setJMSType(type);
    }

    public void setLongProperty(String name, long value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setLongProperty({}, {})", (Object)name, (Object)value);
        }
        this.message.setLongProperty(name, value);
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        logger.trace("setObjectProperty({}, {})", (Object)name, value);
        this.message.setObjectProperty(name, value);
    }

    public void setShortProperty(String name, short value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setShortProperty({}, {})", (Object)name, (Object)value);
        }
        this.message.setShortProperty(name, value);
    }

    public void setStringProperty(String name, String value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setStringProperty({}, {})", (Object)name, (Object)value);
        }
        this.message.setStringProperty(name, value);
    }

    public long getJMSDeliveryTime() throws JMSException {
        logger.trace("getJMSDeliveryTime()");
        return this.message.getJMSDeliveryTime();
    }

    public void setJMSDeliveryTime(long deliveryTime) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setJMSDeliveryTime({})", (Object)deliveryTime);
        }
        this.message.setJMSDeliveryTime(deliveryTime);
    }

    public <T> T getBody(Class<T> c) throws JMSException {
        logger.trace("getBody({})", c);
        return (T)this.message.getBody(c);
    }

    public boolean isBodyAssignableTo(Class c) throws JMSException {
        logger.trace("isBodyAssignableTo({})", (Object)c);
        return this.message.isBodyAssignableTo(c);
    }

    public int hashCode() {
        logger.trace("hashCode()");
        return this.message.hashCode();
    }

    public boolean equals(Object object) {
        logger.trace("equals({})", object);
        if (object != null && object instanceof ActiveMQRAMessage) {
            return this.message.equals(((ActiveMQRAMessage)object).message);
        }
        return this.message.equals(object);
    }

    public String toString() {
        logger.trace("toString()");
        return this.message.toString();
    }
}

