/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.ha;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;

public class ScaleDownPolicy {
    private List<String> connectors = new ArrayList<String>();
    private String discoveryGroup = null;
    private String groupName = null;
    private String clusterName;
    private boolean enabled;

    public ScaleDownPolicy() {
    }

    public ScaleDownPolicy(List<String> connectors, String groupName, String clusterName, boolean enabled) {
        this.connectors = connectors;
        this.groupName = groupName;
        this.clusterName = clusterName;
        this.enabled = enabled;
    }

    public ScaleDownPolicy(String discoveryGroup, String groupName, String clusterName, boolean enabled) {
        this.discoveryGroup = discoveryGroup;
        this.groupName = groupName;
        this.clusterName = clusterName;
        this.enabled = enabled;
    }

    public List<String> getConnectors() {
        return this.connectors;
    }

    public void setConnectors(List<String> connectors) {
        this.connectors = connectors;
    }

    public String getDiscoveryGroup() {
        return this.discoveryGroup;
    }

    public void setDiscoveryGroup(String discoveryGroup) {
        this.discoveryGroup = discoveryGroup;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public static ServerLocatorInternal getScaleDownConnector(ScaleDownPolicy scaleDownPolicy, ActiveMQServer activeMQServer) throws ActiveMQException {
        if (!scaleDownPolicy.getConnectors().isEmpty()) {
            return (ServerLocatorInternal)ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])ScaleDownPolicy.connectorNameListToArray(scaleDownPolicy.getConnectors(), activeMQServer));
        }
        if (scaleDownPolicy.getDiscoveryGroup() != null) {
            DiscoveryGroupConfiguration dg = activeMQServer.getConfiguration().getDiscoveryGroupConfigurations().get(scaleDownPolicy.getDiscoveryGroup());
            if (dg == null) {
                throw ActiveMQMessageBundle.BUNDLE.noDiscoveryGroupFound(dg);
            }
            return (ServerLocatorInternal)ActiveMQClient.createServerLocatorWithHA((DiscoveryGroupConfiguration)dg);
        }
        Map<String, TransportConfiguration> connectorConfigurations = activeMQServer.getConfiguration().getConnectorConfigurations();
        for (TransportConfiguration transportConfiguration : connectorConfigurations.values()) {
            if (!transportConfiguration.getFactoryClassName().equals(InVMConnectorFactory.class.getName())) continue;
            return (ServerLocatorInternal)ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{transportConfiguration});
        }
        throw ActiveMQMessageBundle.BUNDLE.noConfigurationFoundForScaleDown();
    }

    private static TransportConfiguration[] connectorNameListToArray(List<String> connectorNames, ActiveMQServer activeMQServer) {
        TransportConfiguration[] tcConfigs = (TransportConfiguration[])Array.newInstance(TransportConfiguration.class, connectorNames.size());
        int count = 0;
        for (String connectorName : connectorNames) {
            TransportConfiguration connector = activeMQServer.getConfiguration().getConnectorConfigurations().get(connectorName);
            if (connector == null) {
                ActiveMQServerLogger.LOGGER.bridgeNoConnector(connectorName);
                return null;
            }
            tcConfigs[count++] = connector;
        }
        return tcConfigs;
    }
}

