/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.settings.impl;

import java.io.Serializable;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.utils.BufferHelper;

public class ResourceLimitSettings
implements Serializable,
EncodingSupport {
    private static final long serialVersionUID = -110638321333856932L;
    public static final SimpleString DEFAULT_MATCH = null;
    public static final Integer DEFAULT_MAX_CONNECTIONS = -1;
    public static final Integer DEFAULT_MAX_QUEUES = -1;
    SimpleString match = null;
    Integer maxConnections = null;
    Integer maxQueues = null;

    public SimpleString getMatch() {
        return this.match != null ? this.match : DEFAULT_MATCH;
    }

    public int getMaxConnections() {
        return this.maxConnections != null ? this.maxConnections : DEFAULT_MAX_CONNECTIONS;
    }

    public int getMaxQueues() {
        return this.maxQueues != null ? this.maxQueues : DEFAULT_MAX_QUEUES;
    }

    public void setMatch(SimpleString match) {
        this.match = match;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void setMaxQueues(int maxQueues) {
        this.maxQueues = maxQueues;
    }

    public int getEncodeSize() {
        return SimpleString.sizeofNullableString((SimpleString)this.match) + BufferHelper.sizeOfNullableInteger((Integer)this.maxConnections) + BufferHelper.sizeOfNullableInteger((Integer)this.maxQueues);
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeNullableSimpleString(this.match);
        BufferHelper.writeNullableInteger((ActiveMQBuffer)buffer, (Integer)this.maxConnections);
        BufferHelper.writeNullableInteger((ActiveMQBuffer)buffer, (Integer)this.maxQueues);
    }

    public void decode(ActiveMQBuffer buffer) {
        this.match = buffer.readNullableSimpleString();
        this.maxConnections = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        this.maxQueues = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
        result = 31 * result + (this.maxConnections == null ? 0 : this.maxConnections.hashCode());
        result = 31 * result + (this.maxQueues == null ? 0 : this.maxQueues.hashCode());
        return result;
    }

    public String toString() {
        return "ResourceLimitSettings [match=" + this.match + ", maxConnections=" + this.maxConnections + ", maxQueues=" + this.maxQueues + "]";
    }
}

