/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.transaction.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.transaction.ResourceManager;
import org.apache.activemq.artemis.core.transaction.Transaction;

public class ResourceManagerImpl
implements ResourceManager {
    private final ConcurrentMap<Xid, Transaction> transactions = new ConcurrentHashMap<Xid, Transaction>();
    private final List<HeuristicCompletionHolder> heuristicCompletions = new ArrayList<HeuristicCompletionHolder>();
    private final int defaultTimeoutSeconds;
    private boolean started = false;
    private TxTimeoutHandler task;
    private final long txTimeoutScanPeriod;
    private final ScheduledExecutorService scheduledThreadPool;

    public ResourceManagerImpl(int defaultTimeoutSeconds, long txTimeoutScanPeriod, ScheduledExecutorService scheduledThreadPool) {
        this.defaultTimeoutSeconds = defaultTimeoutSeconds;
        this.txTimeoutScanPeriod = txTimeoutScanPeriod;
        this.scheduledThreadPool = scheduledThreadPool;
    }

    public void start() throws Exception {
        if (this.started) {
            return;
        }
        this.task = new TxTimeoutHandler();
        ScheduledFuture<?> future = this.scheduledThreadPool.scheduleAtFixedRate(this.task, this.txTimeoutScanPeriod, this.txTimeoutScanPeriod, TimeUnit.MILLISECONDS);
        this.task.setFuture(future);
        this.started = true;
    }

    public void stop() throws Exception {
        if (!this.started) {
            return;
        }
        if (this.task != null) {
            this.task.close();
        }
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public Transaction getTransaction(Xid xid) {
        return (Transaction)this.transactions.get(xid);
    }

    @Override
    public boolean putTransaction(Xid xid, Transaction tx) {
        return this.transactions.putIfAbsent(xid, tx) == null;
    }

    @Override
    public Transaction removeTransaction(Xid xid) {
        return (Transaction)this.transactions.remove(xid);
    }

    @Override
    public int getTimeoutSeconds() {
        return this.defaultTimeoutSeconds;
    }

    @Override
    public List<Xid> getPreparedTransactions() {
        ArrayList<Xid> xids = new ArrayList<Xid>();
        for (Map.Entry entry : this.transactions.entrySet()) {
            if (((Transaction)entry.getValue()).getState() != Transaction.State.PREPARED) continue;
            xids.add((Xid)entry.getKey());
        }
        return xids;
    }

    @Override
    public Map<Xid, Long> getPreparedTransactionsWithCreationTime() {
        HashMap<Xid, Long> xidsWithCreationTime = new HashMap<Xid, Long>();
        for (Map.Entry entry : this.transactions.entrySet()) {
            xidsWithCreationTime.put((Xid)entry.getKey(), ((Transaction)entry.getValue()).getCreateTime());
        }
        return xidsWithCreationTime;
    }

    @Override
    public void putHeuristicCompletion(long recordID, Xid xid, boolean isCommit) {
        this.heuristicCompletions.add(new HeuristicCompletionHolder(recordID, xid, isCommit));
    }

    @Override
    public List<Xid> getHeuristicCommittedTransactions() {
        return this.getHeuristicCompletedTransactions(true);
    }

    @Override
    public List<Xid> getHeuristicRolledbackTransactions() {
        return this.getHeuristicCompletedTransactions(false);
    }

    @Override
    public long removeHeuristicCompletion(Xid xid) {
        Iterator<HeuristicCompletionHolder> iterator = this.heuristicCompletions.iterator();
        while (iterator.hasNext()) {
            HeuristicCompletionHolder holder = iterator.next();
            if (!holder.xid.equals(xid)) continue;
            iterator.remove();
            return holder.recordID;
        }
        return -1L;
    }

    @Override
    public List<Xid> getInDoubtTransactions() {
        LinkedList<Xid> xids = new LinkedList<Xid>();
        xids.addAll(this.getPreparedTransactions());
        xids.addAll(this.getHeuristicCommittedTransactions());
        xids.addAll(this.getHeuristicRolledbackTransactions());
        return xids;
    }

    private List<Xid> getHeuristicCompletedTransactions(boolean isCommit) {
        ArrayList<Xid> xids = new ArrayList<Xid>();
        for (HeuristicCompletionHolder holder : this.heuristicCompletions) {
            if (holder.isCommit != isCommit) continue;
            xids.add(holder.xid);
        }
        return xids;
    }

    private static final class HeuristicCompletionHolder {
        public final boolean isCommit;
        public final Xid xid;
        public final long recordID;

        private HeuristicCompletionHolder(long recordID, Xid xid, boolean isCommit) {
            this.recordID = recordID;
            this.xid = xid;
            this.isCommit = isCommit;
        }
    }

    private class TxTimeoutHandler
    implements Runnable {
        private boolean closed = false;
        private Future<?> future;

        private TxTimeoutHandler() {
        }

        @Override
        public void run() {
            if (this.closed) {
                return;
            }
            HashSet<Transaction> timedoutTransactions = new HashSet<Transaction>();
            long now = System.currentTimeMillis();
            for (Transaction tx : ResourceManagerImpl.this.transactions.values()) {
                Transaction removedTX;
                if (!tx.hasTimedOut(now, ResourceManagerImpl.this.defaultTimeoutSeconds) || (removedTX = ResourceManagerImpl.this.removeTransaction(tx.getXid())) == null) continue;
                ActiveMQServerLogger.LOGGER.timedOutXID(removedTX.getXid());
                timedoutTransactions.add(removedTX);
            }
            for (Transaction failedTransaction : timedoutTransactions) {
                try {
                    failedTransaction.rollback();
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorTimingOutTX(e, failedTransaction.getXid());
                }
            }
        }

        synchronized void setFuture(Future<?> future) {
            this.future = future;
        }

        void close() {
            if (this.future != null) {
                this.future.cancel(false);
            }
            this.closed = true;
        }
    }
}

