/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisBindingMessage;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.WSDL20DefaultValueHolder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.PolicyUtil;
import org.apache.axis2.util.WSDLSerializationUtil;
import org.apache.neethi.Policy;

public class AxisBinding
extends AxisDescription {
    private QName name;
    private String type;
    private Map options = new HashMap();
    private Map faults = new HashMap();

    public AxisBindingMessage getFault(String name) {
        return (AxisBindingMessage)this.faults.get(name);
    }

    public void addFault(AxisBindingMessage fault) {
        this.faults.put(fault.getName(), fault);
    }

    public void setProperty(String name, Object value) {
        this.options.put(name, value);
    }

    public Object getProperty(String name) {
        Object obj = this.options.get(name);
        if (obj != null) {
            return obj;
        }
        obj = WSDL20DefaultValueHolder.getDefaultValue(name);
        return obj;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object getKey() {
        return null;
    }

    public void engageModule(AxisModule axisModule, AxisConfiguration axisConfig) throws AxisFault {
        throw new UnsupportedOperationException("Sorry we do not support this");
    }

    public boolean isEngaged(String moduleName) {
        throw new UnsupportedOperationException("axisMessage.isEngaged() is not supported");
    }

    public OMElement toWSDL20(OMNamespace wsdl, OMNamespace tns, OMNamespace wsoap, OMNamespace whttp, String interfaceName, Map nameSpaceMap, String addressingFlag) {
        Iterator iterator;
        String property;
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMElement bindingElement = omFactory.createOMElement("binding", wsdl);
        bindingElement.addAttribute(omFactory.createOMAttribute("name", null, this.name.getLocalPart()));
        bindingElement.addAttribute(omFactory.createOMAttribute("interface", null, tns.getPrefix() + ":" + interfaceName));
        if ("http://www.w3.org/ns/wsdl/soap".equals(this.type) || "http://schemas.xmlsoap.org/soap/http".equals(this.type) || "http://www.w3.org/2003/05/http".equals(this.type)) {
            ArrayList soapModules;
            property = (String)this.options.get("wsoap:version");
            if (property != null) {
                if ("http://schemas.xmlsoap.org/soap/envelope/".equals(property)) {
                    bindingElement.addAttribute(omFactory.createOMAttribute("version", wsoap, "1.1"));
                } else {
                    bindingElement.addAttribute(omFactory.createOMAttribute("version", wsoap, "1.2"));
                }
            }
            if ((property = (String)this.options.get("wsoap:protocol")) != null) {
                bindingElement.addAttribute(omFactory.createOMAttribute("protocol", wsoap, property));
            }
            if ((property = (String)this.options.get("wsoap:mep")) != null) {
                bindingElement.addAttribute(omFactory.createOMAttribute("mepDefault", wsoap, property));
            }
            if ((soapModules = (ArrayList)this.options.get("wsoap:module")) != null && soapModules.size() > 0) {
                WSDLSerializationUtil.addSOAPModuleElements(omFactory, soapModules, wsoap, bindingElement);
            }
            WSDLSerializationUtil.addWSAddressingToBinding(addressingFlag, omFactory, bindingElement);
        } else if ("http://www.w3.org/ns/wsdl/http".equals(this.type) && (property = (String)this.options.get("whttp:method")) != null) {
            bindingElement.addAttribute(omFactory.createOMAttribute("methodDefault", whttp, property));
        }
        property = this.getType();
        if (property != null) {
            bindingElement.addAttribute(omFactory.createOMAttribute("type", null, property));
        }
        if ((property = (String)this.options.get("whttp:contentEncoding")) != null) {
            bindingElement.addAttribute(omFactory.createOMAttribute("contentEncodingDefault", whttp, property));
        }
        if ((property = (String)this.options.get("whttp:queryParameterSeparator")) != null) {
            bindingElement.addAttribute(omFactory.createOMAttribute("queryParameterSeparatorDefault", whttp, property));
        }
        if (this.faults != null) {
            iterator = this.faults.values().iterator();
            while (iterator.hasNext()) {
                AxisBindingMessage axisBindingFault = (AxisBindingMessage)iterator.next();
                bindingElement.addChild((OMNode)axisBindingFault.toWSDL20(wsdl, tns, wsoap, whttp, nameSpaceMap));
            }
        }
        iterator = this.getChildren();
        while (iterator.hasNext()) {
            AxisBindingOperation axisBindingOperation = (AxisBindingOperation)iterator.next();
            bindingElement.addChild((OMNode)axisBindingOperation.toWSDL20(wsdl, tns, wsoap, whttp, this.type, nameSpaceMap));
        }
        return bindingElement;
    }

    public Policy getEffectivePolicy() {
        Policy effectivePolicy;
        ArrayList<Policy> policyList = new ArrayList<Policy>();
        policyList.addAll(this.getPolicyInclude().getAttachedPolicies());
        AxisEndpoint axisEndpoint = (AxisEndpoint)this.getParent();
        if (axisEndpoint != null) {
            policyList.addAll(axisEndpoint.getPolicyInclude().getAttachedPolicies());
        }
        AxisService service = null;
        if (axisEndpoint != null) {
            service = (AxisService)axisEndpoint.getParent();
        }
        if (service != null && (effectivePolicy = service.getPolicyInclude().getEffectivePolicy()) != null) {
            policyList.add(effectivePolicy);
        }
        return PolicyUtil.getMergedPolicy(policyList, this);
    }
}

