/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.io.InputStream;
import javax.xml.namespace.QName;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.OutInAxisOperationClient;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.util.Utils;

public class RobustOutOnlyAxisOperation
extends OutInAxisOperation {
    public RobustOutOnlyAxisOperation() {
        QName tmpName = new QName(this.getClass().getName() + "_" + UUIDGenerator.getUUID());
        this.setName(tmpName);
        this.setMessageExchangePattern("http://www.w3.org/ns/wsdl/robust-out-only");
    }

    public RobustOutOnlyAxisOperation(QName name) {
        super(name);
        this.setMessageExchangePattern("http://www.w3.org/ns/wsdl/robust-out-only");
    }

    public OperationClient createClient(ServiceContext sc, Options options) {
        return new RobustOutOnlyOperationClient(this, sc, options);
    }

    class RobustOutOnlyOperationClient
    extends OutInAxisOperationClient {
        public RobustOutOnlyOperationClient(OutInAxisOperation axisOp, ServiceContext sc, Options options) {
            super(axisOp, sc, options);
        }

        protected MessageContext send(MessageContext msgctx) throws AxisFault {
            AxisEngine engine = new AxisEngine(msgctx.getConfigurationContext());
            MessageContext responseMessageContext = ContextFactory.createMessageContext(msgctx.getConfigurationContext());
            responseMessageContext.setOptions(this.options);
            responseMessageContext.setServerSide(false);
            responseMessageContext.setMessageID(msgctx.getMessageID());
            this.addMessageContext(responseMessageContext);
            responseMessageContext.setServiceContext(msgctx.getServiceContext());
            responseMessageContext.setAxisMessage(msgctx.getAxisOperation().getMessage("In"));
            engine.send(msgctx);
            responseMessageContext.setDoingREST(msgctx.isDoingREST());
            responseMessageContext.setProperty("TRANSPORT_IN", msgctx.getProperty("TRANSPORT_IN"));
            responseMessageContext.setTransportIn(msgctx.getTransportIn());
            responseMessageContext.setTransportOut(msgctx.getTransportOut());
            responseMessageContext.setProperty("TRANSPORT_HEADERS", msgctx.getProperty("TRANSPORT_HEADERS"));
            SOAPEnvelope envelope = responseMessageContext.getEnvelope();
            if (envelope == null) {
                InputStream inStream = (InputStream)responseMessageContext.getProperty("TRANSPORT_IN");
                if (inStream != null) {
                    envelope = TransportUtils.createSOAPMessage(responseMessageContext);
                    responseMessageContext.setEnvelope(envelope);
                }
                responseMessageContext.setEnvelope(envelope);
            }
            if (envelope != null && envelope.getBody().hasFault()) {
                engine.receiveFault(responseMessageContext);
                AxisFault af = Utils.getInboundFaultFromMessageContext(responseMessageContext);
                throw af;
            }
            return null;
        }
    }
}

