/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.http.util.URLTemplatingUtil;

public class ApplicationXMLFormatter
implements MessageFormatter {
    public byte[] getBytes(MessageContext messageContext, OMOutputFormat format) throws AxisFault {
        OMElement omElement;
        if (messageContext.getFLOW() == 4) {
            SOAPFault fault = messageContext.getEnvelope().getBody().getFault();
            SOAPFaultDetail soapFaultDetail = fault.getDetail();
            omElement = soapFaultDetail.getFirstElement();
            if (omElement == null) {
                omElement = fault.getReason();
            }
        } else {
            omElement = messageContext.getEnvelope().getBody().getFirstElement();
        }
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        if (omElement != null) {
            try {
                omElement.serializeAndConsume((OutputStream)bytesOut, format);
            }
            catch (XMLStreamException e) {
                throw new AxisFault(e);
            }
            return bytesOut.toByteArray();
        }
        return new byte[0];
    }

    public void writeTo(MessageContext messageContext, OMOutputFormat format, OutputStream outputStream, boolean preserve) throws AxisFault {
        OMElement omElement;
        if (messageContext.getFLOW() == 4) {
            SOAPFault fault = messageContext.getEnvelope().getBody().getFault();
            SOAPFaultDetail soapFaultDetail = fault.getDetail();
            omElement = soapFaultDetail.getFirstElement();
            if (omElement == null) {
                omElement = fault.getReason();
            }
        } else {
            omElement = messageContext.getEnvelope().getBody().getFirstElement();
        }
        if (omElement != null) {
            try {
                omElement.serializeAndConsume(outputStream, format);
            }
            catch (XMLStreamException e) {
                throw new AxisFault(e);
            }
        }
        try {
            outputStream.flush();
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
    }

    public String getContentType(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        String encoding = format.getCharSetEncoding();
        String contentType = (String)messageContext.getProperty("ContentType");
        if (contentType == null) {
            contentType = "application/xml";
        }
        if (encoding != null) {
            contentType = contentType + "; charset=" + encoding;
        }
        if (soapAction != null && !"".equals(soapAction.trim()) && !"\"\"".equals(soapAction.trim())) {
            contentType = contentType + ";action=\"" + soapAction + "\";";
        }
        return contentType;
    }

    public URL getTargetAddress(MessageContext messageContext, OMOutputFormat format, URL targetURL) throws AxisFault {
        targetURL = URLTemplatingUtil.getTemplatedURL(targetURL, messageContext, false);
        return targetURL;
    }

    public String formatSOAPAction(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        return soapAction;
    }
}

