/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.SocketException;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.ContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.deployment.WarBasedAxisConfigurator;
import org.apache.axis2.description.AxisBindingMessage;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.ListingAgent;
import org.apache.axis2.transport.http.ServletBasedOutTransportInfo;
import org.apache.axis2.transport.http.TransportHeaders;
import org.apache.axis2.transport.http.server.HttpUtils;
import org.apache.axis2.transport.http.util.RESTUtil;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxisServlet
extends HttpServlet
implements TransportListener {
    private static final Log log = LogFactory.getLog((Class)AxisServlet.class);
    public static final String CONFIGURATION_CONTEXT = "CONFIGURATION_CONTEXT";
    public static final String SESSION_ID = "SessionId";
    protected transient ConfigurationContext configContext;
    protected transient AxisConfiguration axisConfiguration;
    protected transient ServletConfig servletConfig;
    private transient ListingAgent agent;
    private String contextRoot = null;
    protected boolean disableREST = false;
    private static final String LIST_SERVICES_SUFIX = "/services/listServices";
    private static final String LIST_FAUKT_SERVICES_SUFIX = "/services/ListFaultyServices";
    private boolean closeReader = true;
    private static final int BUFFER_SIZE = 8192;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setBufferSize(8192);
        this.initContextRoot(request);
        ServletOutputStream out = response.getOutputStream();
        String contentType = request.getContentType();
        if (!HTTPTransportUtils.isRESTRequest(contentType)) {
            MessageContext msgContext = this.createMessageContext(request, response);
            msgContext.setProperty("ContentType", contentType);
            try {
                Handler.InvocationResponse pi = HTTPTransportUtils.processHTTPPostRequest(msgContext, new BufferedInputStream((InputStream)request.getInputStream()), new BufferedOutputStream((OutputStream)out), contentType, request.getHeader("SOAPAction"), request.getRequestURL().toString());
                Boolean holdResponse = (Boolean)msgContext.getProperty("HoldResponse");
                if (pi.equals(Handler.InvocationResponse.SUSPEND) || holdResponse != null && Boolean.TRUE.equals(holdResponse)) {
                    ((RequestResponseTransport)msgContext.getProperty("RequestResponseTransportControl")).awaitResponse();
                }
                Object contextWritten = null;
                OperationContext operationContext = msgContext.getOperationContext();
                if (operationContext != null) {
                    contextWritten = operationContext.getProperty("CONTENT_WRITTEN");
                }
                response.setContentType("text/xml; charset=" + msgContext.getProperty("CHARACTER_SET_ENCODING"));
                if (contextWritten != null && "true".equals(contextWritten)) return;
                response.setStatus(202);
                return;
            }
            catch (AxisFault e) {
                log.debug((Object)e);
                if (msgContext == null) throw new ServletException((Throwable)e);
                this.processAxisFault(msgContext, response, (OutputStream)out, e);
                return;
            }
            catch (Throwable t) {
                log.error((Object)t);
                if (msgContext == null) throw new ServletException(t);
                try {
                    if (AddressingHelper.isFaultRedirected(msgContext)) {
                        response.setStatus(202);
                    } else {
                        Integer code;
                        response.setStatus(500);
                        AxisBindingOperation axisBindingOperation = (AxisBindingOperation)msgContext.getProperty("AxisBindingOperation");
                        if (axisBindingOperation != null && (code = (Integer)axisBindingOperation.getFault((String)msgContext.getProperty("faultName")).getProperty("whttp:code")) != null) {
                            response.setStatus(code.intValue());
                        }
                    }
                    this.handleFault(msgContext, (OutputStream)out, new AxisFault(t.toString(), t));
                }
                catch (AxisFault e2) {
                    log.info((Object)e2);
                    throw new ServletException((Throwable)e2);
                }
                this.closeStaxBuilder(msgContext);
                return;
            }
        }
        if (!this.disableREST) {
            new ProcessRESTRequest("POST", request, response).processXMLRequest();
            return;
        } else {
            this.disableRESTErrorMessage(response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.initContextRoot(request);
        String requestURI = request.getRequestURI();
        String query = request.getQueryString();
        if (query != null && (query.indexOf("wsdl2") >= 0 || query.indexOf("wsdl") >= 0 || query.indexOf("xsd") >= 0 || query.indexOf("policy") >= 0)) {
            this.agent.processListService(request, response);
        } else if (requestURI.endsWith(".xsd") || requestURI.endsWith(".wsdl")) {
            this.agent.processExplicitSchemaAndWSDL(request, response);
        } else if (requestURI.endsWith(LIST_SERVICES_SUFIX) || requestURI.endsWith(LIST_FAUKT_SERVICES_SUFIX)) {
            try {
                this.agent.handle(request, response);
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        } else if (!this.disableREST) {
            new ProcessRESTRequest("GET", request, response).processURLRequest();
        } else {
            this.disableRESTErrorMessage(response);
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.initContextRoot(request);
        if (!this.disableREST) {
            new ProcessRESTRequest("DELETE", request, response).processURLRequest();
        } else {
            this.disableRESTErrorMessage(response);
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.initContextRoot(request);
        if (!this.disableREST) {
            new ProcessRESTRequest("PUT", request, response).processXMLRequest();
        } else {
            this.disableRESTErrorMessage(response);
        }
    }

    protected void disableRESTErrorMessage(HttpServletResponse response) throws IOException {
        PrintWriter writer = new PrintWriter((OutputStream)response.getOutputStream());
        writer.println("<html><body><h2>Please enable REST support in WEB-INF/conf/axis2.xml and WEB-INF/web.xml</h2></body></html>");
        writer.flush();
        response.setStatus(202);
    }

    private void closeStaxBuilder(MessageContext messageContext) throws ServletException {
        if (this.closeReader && messageContext != null) {
            try {
                StAXBuilder builder = (StAXBuilder)messageContext.getEnvelope().getBuilder();
                if (builder != null) {
                    builder.close();
                }
            }
            catch (Exception e) {
                log.debug((Object)e);
                throw new ServletException((Throwable)e);
            }
        }
    }

    private void processAxisFault(MessageContext msgContext, HttpServletResponse res, OutputStream out, AxisFault e) {
        try {
            if (AddressingHelper.isFaultRedirected(msgContext)) {
                res.setStatus(202);
            } else {
                Integer code;
                AxisBindingMessage fault;
                res.setStatus(500);
                AxisBindingOperation axisBindingOperation = (AxisBindingOperation)msgContext.getProperty("AxisBindingOperation");
                if (axisBindingOperation != null && (fault = axisBindingOperation.getFault((String)msgContext.getProperty("faultName"))) != null && (code = (Integer)fault.getProperty("whttp:code")) != null) {
                    res.setStatus(code.intValue());
                }
            }
            this.handleFault(msgContext, out, e);
        }
        catch (AxisFault e2) {
            log.info((Object)e2);
        }
    }

    protected void handleFault(MessageContext msgContext, OutputStream out, AxisFault e) throws AxisFault {
        msgContext.setProperty("TRANSPORT_OUT", out);
        AxisEngine engine = new AxisEngine(this.configContext);
        MessageContext faultContext = MessageContextBuilder.createFaultMessageContext(msgContext, e);
        msgContext.setEnvelope(faultContext.getEnvelope());
        HttpServletResponse response = (HttpServletResponse)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE);
        if (response != null) {
            SOAPFaultCode code = faultContext.getEnvelope().getBody().getFault().getCode();
            OMElement valueElement = null;
            if (code != null) {
                valueElement = code.getFirstChildWithName(new QName("http://www.w3.org/2003/05/soap-envelope", "Value"));
            }
            if (valueElement != null && valueElement.getText().trim().indexOf("Sender") > -1 && !msgContext.isDoingREST()) {
                response.setStatus(400);
            }
        }
        engine.sendFault(faultContext);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.servletConfig = config;
            this.configContext = this.initConfigContext(config);
            this.axisConfiguration = this.configContext.getAxisConfiguration();
            config.getServletContext().setAttribute(CONFIGURATION_CONTEXT, (Object)this.configContext);
            ListenerManager listenerManager = new ListenerManager();
            listenerManager.init(this.configContext);
            TransportInDescription transportInDescription = new TransportInDescription("http");
            transportInDescription.setReceiver(this);
            listenerManager.addListener(transportInDescription, true);
            listenerManager.start();
            ListenerManager.defaultConfigurationContext = this.configContext;
            this.agent = new ListingAgent(this.configContext);
            this.initParams();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        try {
            if (this.configContext != null) {
                this.configContext.terminate();
            }
        }
        catch (AxisFault axisFault) {
            log.info((Object)axisFault.getMessage());
        }
        try {
            super.destroy();
        }
        catch (Exception e) {
            log.info((Object)e.getMessage());
        }
    }

    protected void initParams() {
        Parameter parameter = this.axisConfiguration.getParameter("disableREST");
        if (parameter != null) {
            boolean bl = this.disableREST = !JavaUtils.isFalseExplicitly(parameter.getValue());
        }
        if ((parameter = this.axisConfiguration.getParameter("axis2.close.reader")) != null) {
            this.closeReader = JavaUtils.isTrueExplicitly(parameter.getValue());
        }
    }

    public void init() throws ServletException {
        if (this.servletConfig != null) {
            this.init(this.servletConfig);
        }
    }

    protected ConfigurationContext initConfigContext(ServletConfig config) throws ServletException {
        try {
            ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContext(new WarBasedAxisConfigurator(config));
            configContext.setProperty("ContainerManaged", "true");
            return configContext;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void initContextRoot(HttpServletRequest req) {
        if (this.contextRoot != null && this.contextRoot.trim().length() != 0) {
            return;
        }
        boolean findContext = true;
        String findContextParameter = this.servletConfig.getInitParameter("axis2.find.context");
        if (findContextParameter != null) {
            findContextParameter = findContextParameter.trim();
            findContext = JavaUtils.isTrue(findContextParameter);
        }
        if (!findContext && this.contextRoot == null) {
            this.contextRoot = this.configContext.getContextRoot();
        }
        if (this.contextRoot == null || this.contextRoot.trim().length() == 0) {
            String[] parts = JavaUtils.split(req.getContextPath(), '/');
            if (parts != null) {
                for (int i = 0; i < parts.length; ++i) {
                    if (parts[i].length() <= 0) continue;
                    this.contextRoot = parts[i];
                    break;
                }
            }
            if (this.contextRoot == null || req.getContextPath().equals("/")) {
                this.contextRoot = "/";
            }
            this.configContext.setContextRoot(this.contextRoot);
        }
    }

    protected Map getTransportHeaders(HttpServletRequest req) {
        return new TransportHeaders(req);
    }

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        return this.getEPRsForService(serviceName, ip)[0];
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        String port = (String)this.configContext.getProperty("RUNNING_PORT");
        if (port == null) {
            port = "8080";
        }
        if (ip == null) {
            try {
                ip = HttpUtils.getIpAddress();
                if (ip == null) {
                    ip = "localhost";
                }
            }
            catch (SocketException e) {
                throw new AxisFault(e);
            }
        }
        EndpointReference endpoint = new EndpointReference("http://" + ip + ":" + port + '/' + this.configContext.getServiceContextPath() + "/" + serviceName);
        return new EndpointReference[]{endpoint};
    }

    public void init(ConfigurationContext axisConf, TransportInDescription transprtIn) throws AxisFault {
    }

    public void start() throws AxisFault {
    }

    public void stop() throws AxisFault {
    }

    protected MessageContext createMessageContext(HttpServletRequest request, HttpServletResponse response, boolean invocationType) throws IOException {
        String query;
        MessageContext msgContext = ContextFactory.createMessageContext(this.configContext);
        String requestURI = request.getRequestURI();
        String trsPrefix = request.getRequestURL().toString();
        int sepindex = trsPrefix.indexOf(58);
        if (sepindex > -1) {
            trsPrefix = trsPrefix.substring(0, sepindex);
            msgContext.setIncomingTransportName(trsPrefix);
        } else {
            msgContext.setIncomingTransportName("http");
        }
        TransportInDescription transportIn = this.axisConfiguration.getTransportIn(msgContext.getIncomingTransportName());
        TransportOutDescription transportOut = this.configContext.getAxisConfiguration().getTransportOut("http");
        msgContext.setTransportIn(transportIn);
        msgContext.setTransportOut(transportOut);
        msgContext.setServerSide(true);
        if (!invocationType && (query = request.getQueryString()) != null) {
            requestURI = requestURI + "?" + query;
        }
        msgContext.setTo(new EndpointReference(requestURI));
        msgContext.setFrom(new EndpointReference(request.getRemoteAddr()));
        msgContext.setProperty("REMOTE_ADDR", request.getRemoteAddr());
        msgContext.setProperty("OutTransportInfo", new ServletBasedOutTransportInfo(response));
        msgContext.setProperty("TRANSPORT_HEADERS", this.getTransportHeaders(request));
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, request);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, response);
        msgContext.setProperty("RequestResponseTransportControl", new ServletRequestResponseTransport(response));
        return msgContext;
    }

    protected MessageContext createMessageContext(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        return this.createMessageContext(req, resp, true);
    }

    public SessionContext getSessionContext(MessageContext messageContext) {
        HttpServletRequest req = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        SessionContext sessionContext = (SessionContext)req.getSession(true).getAttribute("SessionContext");
        String sessionId = req.getSession().getId();
        if (sessionContext == null) {
            sessionContext = new SessionContext(null);
            sessionContext.setCookieID(sessionId);
            req.getSession().setAttribute("SessionContext", (Object)sessionContext);
        }
        messageContext.setSessionContext(sessionContext);
        messageContext.setProperty(SESSION_ID, sessionId);
        return sessionContext;
    }

    public class ProcessRESTRequest {
        MessageContext messageContext;
        HttpServletRequest request;
        HttpServletResponse response;

        public ProcessRESTRequest(String httpMethodString, HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.request = request;
            this.response = response;
            this.messageContext = AxisServlet.this.createMessageContext(this.request, this.response, false);
            this.messageContext.setProperty("HTTP_METHOD_OBJECT", httpMethodString);
        }

        public void processXMLRequest() throws IOException, ServletException {
            try {
                RESTUtil.processXMLRequest(this.messageContext, (InputStream)this.request.getInputStream(), (OutputStream)this.response.getOutputStream(), this.request.getContentType());
                this.checkResponseWritten();
            }
            catch (AxisFault axisFault) {
                this.processFault(axisFault);
            }
            AxisServlet.this.closeStaxBuilder(this.messageContext);
        }

        public void processURLRequest() throws IOException, ServletException {
            try {
                RESTUtil.processURLRequest(this.messageContext, (OutputStream)this.response.getOutputStream(), this.request.getContentType());
                this.checkResponseWritten();
            }
            catch (AxisFault axisFault) {
                this.processFault(axisFault);
            }
            AxisServlet.this.closeStaxBuilder(this.messageContext);
        }

        private void checkResponseWritten() {
            Object contextWritten = this.messageContext.getOperationContext().getProperty("CONTENT_WRITTEN");
            if (contextWritten == null || !"true".equals(contextWritten)) {
                this.response.setStatus(202);
            }
        }

        private void processFault(AxisFault e) throws ServletException, IOException {
            log.debug((Object)e);
            if (this.messageContext == null) {
                throw new ServletException((Throwable)e);
            }
            AxisServlet.this.processAxisFault(this.messageContext, this.response, (OutputStream)this.response.getOutputStream(), e);
        }
    }

    protected class ServletRequestResponseTransport
    implements RequestResponseTransport {
        private HttpServletResponse response;
        private CountDownLatch responseReadySignal = new CountDownLatch(1);
        RequestResponseTransport.RequestResponseTransportStatus status = RequestResponseTransport.RequestResponseTransportStatus.INITIAL;
        AxisFault faultToBeThrownOut = null;

        ServletRequestResponseTransport(HttpServletResponse response) {
            this.response = response;
        }

        public void acknowledgeMessage(MessageContext msgContext) throws AxisFault {
            log.debug((Object)"Acking one-way request");
            this.response.setContentType("text/xml; charset=" + msgContext.getProperty("CHARACTER_SET_ENCODING"));
            this.response.setStatus(202);
            try {
                this.response.flushBuffer();
            }
            catch (IOException e) {
                throw new AxisFault("Error sending acknowledgement", e);
            }
            this.signalResponseReady();
        }

        public void awaitResponse() throws InterruptedException, AxisFault {
            log.debug((Object)"Blocking servlet thread -- awaiting response");
            this.status = RequestResponseTransport.RequestResponseTransportStatus.WAITING;
            this.responseReadySignal.await();
            if (this.faultToBeThrownOut != null) {
                throw this.faultToBeThrownOut;
            }
        }

        public void signalResponseReady() {
            log.debug((Object)"Signalling response available");
            this.status = RequestResponseTransport.RequestResponseTransportStatus.SIGNALLED;
            this.responseReadySignal.countDown();
        }

        public RequestResponseTransport.RequestResponseTransportStatus getStatus() {
            return this.status;
        }

        public void signalFaultReady(AxisFault fault) {
            this.faultToBeThrownOut = fault;
            this.signalResponseReady();
        }
    }
}

