/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.local;

import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.local.LocalResponder;
import org.apache.axis2.transport.local.LocalTransportSender;

public class LocalTransportReceiver {
    public static ConfigurationContext CONFIG_CONTEXT;
    private ConfigurationContext confContext;
    private LocalTransportSender sender;

    public LocalTransportReceiver(ConfigurationContext configContext) {
        this.confContext = configContext;
    }

    public LocalTransportReceiver(LocalTransportSender sender) {
        this(CONFIG_CONTEXT);
        this.sender = sender;
    }

    public void processMessage(InputStream in, EndpointReference to) throws AxisFault {
        try {
            TransportInDescription tIn = this.confContext.getAxisConfiguration().getTransportIn("local");
            TransportOutDescription tOut = this.confContext.getAxisConfiguration().getTransportOut("local");
            tOut.setSender(new LocalResponder(this.sender));
            MessageContext msgCtx = ContextFactory.createMessageContext(this.confContext);
            msgCtx.setTransportIn(tIn);
            msgCtx.setTransportOut(tOut);
            msgCtx.setTo(to);
            msgCtx.setServerSide(true);
            msgCtx.setProperty("TRANSPORT_OUT", this.sender.getResponse());
            InputStreamReader streamReader = new InputStreamReader(in);
            StAXBuilder builder = BuilderUtil.getBuilder(streamReader);
            SOAPEnvelope envelope = (SOAPEnvelope)builder.getDocumentElement();
            msgCtx.setEnvelope(envelope);
            AxisEngine engine = new AxisEngine(this.confContext);
            if (envelope.getBody().hasFault()) {
                engine.receiveFault(msgCtx);
            } else {
                engine.receive(msgCtx);
            }
        }
        catch (XMLStreamException e) {
            throw new AxisFault(e);
        }
        catch (FactoryConfigurationError e) {
            throw new AxisFault(e);
        }
    }
}

