/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPFaultElement;
import javax.xml.soap.SOAPHeader;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAP11Version;
import org.apache.axiom.soap.SOAP12Version;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.saaj.NodeImpl;
import org.apache.axis2.saaj.PrefixedQName;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPElementImpl<T extends OMElement>
extends NodeImpl<Element, T>
implements SOAPElement {
    private String encodingStyle;

    public SOAPElementImpl(T element) {
        super((Element)element, element);
    }

    public SOAPElement addAttribute(Name name, String value) throws SOAPException {
        if (name.getURI() == null || name.getURI().trim().length() == 0) {
            ((Element)this.target).setAttributeNS("", name.getLocalName(), value);
        } else {
            ((Element)this.target).setAttributeNS(name.getURI(), name.getPrefix() + ":" + name.getLocalName(), value);
        }
        return this;
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        String prefix = name.getPrefix();
        return this.addChildElement(name.getLocalName(), "".equals(prefix) ? null : prefix, name.getURI());
    }

    public SOAPElement addChildElement(SOAPElement soapElement) throws SOAPException {
        SOAPElementImpl<OMElement> childEle;
        String namespaceURI = soapElement.getNamespaceURI();
        String prefix = soapElement.getPrefix();
        String localName = soapElement.getLocalName();
        if (namespaceURI == null || namespaceURI.trim().length() == 0) {
            childEle = new SOAPElementImpl<OMElement>((OMElement)this.getOwnerDocument().createElementNS(null, localName));
        } else {
            ((OMElement)this.omTarget).declareNamespace(namespaceURI, prefix);
            childEle = new SOAPElementImpl<OMElement>((OMElement)((Element)this.target).getOwnerDocument().createElementNS(namespaceURI, localName));
        }
        Iterator iter = soapElement.getAllAttributes();
        while (iter.hasNext()) {
            Name name = (Name)iter.next();
            childEle.addAttribute(name, soapElement.getAttributeValue(name));
        }
        iter = soapElement.getChildElements();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof Text) {
                childEle.addTextNode(((Text)o).getData());
                continue;
            }
            childEle.addChildElement((SOAPElement)o);
        }
        ((Element)childEle.target).setUserData("saaj.node", childEle, null);
        if (namespaceURI != null && namespaceURI.trim().length() > 0) {
            ((OMElement)childEle.omTarget).setNamespace(((OMElement)childEle.omTarget).declareNamespace(namespaceURI, prefix));
        }
        ((Element)this.target).appendChild(childEle.target);
        ((Element)childEle.target).getParentNode().setUserData("saaj.node", this, null);
        childEle.setParentElement(this);
        return childEle;
    }

    public SOAPElement addChildElement(String localName, String prefix, String namespaceURI) throws SOAPException {
        if (prefix == null) {
            prefix = "";
        }
        SOAPElementImpl childEle = (SOAPElementImpl)((Object)this.getOwnerDocument().createElementNS(namespaceURI, prefix.length() == 0 ? localName : prefix + ":" + localName));
        ((Element)childEle.target).setUserData("saaj.node", childEle, null);
        ((OMElement)childEle.omTarget).setNamespace(prefix.length() == 0 ? ((OMElement)childEle.omTarget).declareDefaultNamespace(namespaceURI) : ((OMElement)childEle.omTarget).declareNamespace(namespaceURI, prefix));
        ((Element)this.target).appendChild(childEle.target);
        ((Element)childEle.target).getParentNode().setUserData("saaj.node", this, null);
        childEle.setParentElement(this);
        return childEle;
    }

    public SOAPElement addChildElement(String localName, String prefix) throws SOAPException {
        String namespaceURI = this.getNamespaceURI(prefix);
        if (namespaceURI == null) {
            throw new SOAPException("Namespace not declared for the give prefix: " + prefix);
        }
        return this.addChildElement(localName, prefix, namespaceURI);
    }

    public SOAPElement addChildElement(String localName) throws SOAPException {
        SOAPElementImpl<OMElement> childEle = new SOAPElementImpl<OMElement>((OMElement)this.getOwnerDocument().createElementNS(null, localName));
        ((Element)childEle.target).setUserData("saaj.node", childEle, null);
        ((Element)this.target).appendChild(childEle.target);
        ((Element)childEle.target).getParentNode().setUserData("saaj.node", this, null);
        childEle.setParentElement(this);
        return childEle;
    }

    public SOAPElement addNamespaceDeclaration(String prefix, String uri) throws SOAPException {
        if (prefix == null || prefix.length() == 0) {
            ((OMElement)this.omTarget).declareDefaultNamespace(uri);
        } else {
            ((OMElement)this.omTarget).declareNamespace(uri, prefix);
        }
        return this;
    }

    public SOAPElement addTextNode(String text) throws SOAPException {
        Text textNode = this.getOwnerDocument().createTextNode(text);
        this.appendChild(textNode);
        return this;
    }

    public Iterator getAllAttributes() {
        Iterator attribIter = ((OMElement)this.omTarget).getAllAttributes();
        ArrayList<PrefixedQName> attribName = new ArrayList<PrefixedQName>();
        while (attribIter.hasNext()) {
            Attr attr = (Attr)attribIter.next();
            PrefixedQName qname = attr.getNamespaceURI() == null || attr.getNamespaceURI().trim().length() == 0 ? new PrefixedQName(attr.getNamespaceURI(), attr.getName(), attr.getPrefix()) : new PrefixedQName(attr.getNamespaceURI(), attr.getLocalName(), attr.getPrefix());
            attribName.add(qname);
        }
        return attribName.iterator();
    }

    public String getAttributeValue(Name name) {
        OMAttribute attribute = ((OMElement)this.omTarget).getAttribute(new QName(name.getURI(), name.getLocalName(), name.getPrefix()));
        if (attribute == null) {
            return null;
        }
        return attribute.getAttributeValue();
    }

    public Iterator getChildElements() {
        Iterator childIter = ((OMElement)this.omTarget).getChildren();
        ArrayList<Node> childElements = new ArrayList<Node>();
        while (childIter.hasNext()) {
            childElements.add(this.toSAAJNode((Node)childIter.next()));
        }
        return childElements.iterator();
    }

    public Iterator getChildElements(Name name) {
        QName qName = new QName(name.getURI(), name.getLocalName());
        Iterator childIter = ((OMElement)this.omTarget).getChildrenWithName(qName);
        ArrayList<Node> childElements = new ArrayList<Node>();
        while (childIter.hasNext()) {
            childElements.add(this.toSAAJNode((Node)childIter.next()));
        }
        return childElements.iterator();
    }

    public Name getElementName() {
        QName qName = ((OMElement)this.omTarget).getQName();
        return new PrefixedQName(qName.getNamespaceURI(), qName.getLocalPart(), qName.getPrefix());
    }

    public String getEncodingStyle() {
        return this.encodingStyle;
    }

    public Iterator getNamespacePrefixes() {
        ArrayList<String> prefixList = new ArrayList<String>();
        Iterator nsIter = ((OMElement)this.omTarget).getAllDeclaredNamespaces();
        while (nsIter.hasNext()) {
            Object o = nsIter.next();
            if (!(o instanceof OMNamespace)) continue;
            OMNamespace ns = (OMNamespace)o;
            prefixList.add(ns.getPrefix());
        }
        return prefixList.iterator();
    }

    public String getNamespaceURI(String prefix) {
        OMNamespace ns = ((OMElement)this.omTarget).findNamespaceURI(prefix);
        return ns != null ? ns.getNamespaceURI() : null;
    }

    public Iterator getVisibleNamespacePrefixes() {
        Iterator namespacesIter = ((OMElement)this.omTarget).getAllDeclaredNamespaces();
        ArrayList<String> returnList = new ArrayList<String>();
        while (namespacesIter.hasNext()) {
            OMNamespace ns;
            Object o = namespacesIter.next();
            if (!(o instanceof OMNamespace) || (ns = (OMNamespace)o).getPrefix() == null) continue;
            returnList.add(ns.getPrefix());
        }
        OMContainer parent = ((OMElement)this.omTarget).getParent();
        if (parent != null && parent instanceof OMElement) {
            Iterator parentScopeNamespacesIter = ((OMElement)parent).getAllDeclaredNamespaces();
            while (parentScopeNamespacesIter.hasNext()) {
                OMNamespace ns;
                Object o = parentScopeNamespacesIter.next();
                if (!(o instanceof OMNamespace) || (ns = (OMNamespace)o).getPrefix() == null) continue;
                returnList.add(ns.getPrefix());
            }
        }
        return returnList.iterator();
    }

    public SOAPElement addAttribute(QName qname, String value) throws SOAPException {
        if (qname.getNamespaceURI() == null || qname.getNamespaceURI().trim().length() == 0) {
            ((Element)this.target).setAttribute(qname.getLocalPart(), value);
        } else {
            ((Element)this.target).setAttributeNS(qname.getNamespaceURI(), qname.getPrefix() + ":" + qname.getLocalPart(), value);
        }
        return this;
    }

    public SOAPElement addChildElement(QName qname) throws SOAPException {
        String prefix = qname.getPrefix();
        return this.addChildElement(qname.getLocalPart(), "".equals(prefix) ? null : prefix, qname.getNamespaceURI());
    }

    public QName createQName(String localName, String prefix) throws SOAPException {
        String namespaceURI = this.getNamespaceURI(prefix);
        if (namespaceURI == null) {
            throw new SOAPException("Invalid prefix");
        }
        return new QName(namespaceURI, localName, prefix);
    }

    public Iterator getAllAttributesAsQNames() {
        Iterator attribIter = ((OMElement)this.omTarget).getAllAttributes();
        ArrayList<QName> attributesAsQNames = new ArrayList<QName>();
        while (attribIter.hasNext()) {
            Attr attr = (Attr)attribIter.next();
            QName qname = new QName(attr.getNamespaceURI(), attr.getName(), attr.getPrefix());
            attributesAsQNames.add(qname);
        }
        return attributesAsQNames.iterator();
    }

    public String getAttributeValue(QName qname) {
        OMAttribute attribute = ((OMElement)this.omTarget).getAttribute(qname);
        if (attribute == null) {
            return null;
        }
        return attribute.getAttributeValue();
    }

    public Iterator getChildElements(QName qname) {
        Iterator childIter = ((OMElement)this.omTarget).getChildrenWithName(qname);
        ArrayList<Node> childElements = new ArrayList<Node>();
        while (childIter.hasNext()) {
            childElements.add(this.toSAAJNode((Node)childIter.next()));
        }
        return childElements.iterator();
    }

    public QName getElementQName() {
        return ((OMElement)this.omTarget).getQName();
    }

    public boolean removeAttribute(QName qname) {
        OMAttribute attr = ((OMElement)this.omTarget).getAttribute(qname);
        if (attr != null) {
            ((OMElement)this.omTarget).removeAttribute(attr);
            return true;
        }
        return false;
    }

    public SOAPElement setElementQName(QName newName) throws SOAPException {
        String localName = ((Element)this.target).getLocalName();
        if ("Body".equals(localName) || "Header".equals(localName) || "Envelope".equals(localName)) {
            throw new SOAPException("changing this element name is not allowed");
        }
        OMNamespace omNamespace = ((OMElement)this.omTarget).getOMFactory().createOMNamespace(newName.getNamespaceURI(), newName.getPrefix());
        ((OMElement)this.omTarget).setNamespace(omNamespace);
        ((OMElement)this.omTarget).setLocalName(newName.getLocalPart());
        return this;
    }

    public boolean removeAttribute(Name name) {
        OMAttribute attr = ((OMElement)this.omTarget).getAttribute(new QName(name.getURI(), name.getLocalName(), name.getPrefix()));
        if (attr != null) {
            ((OMElement)this.omTarget).removeAttribute(attr);
            return true;
        }
        return false;
    }

    public void removeContents() {
        Iterator childIter = ((OMElement)this.omTarget).getChildElements();
        while (childIter.hasNext()) {
            childIter.next();
            childIter.remove();
        }
    }

    public boolean removeNamespaceDeclaration(String prefix) {
        Iterator it = ((OMElement)this.omTarget).getAllDeclaredNamespaces();
        while (it.hasNext()) {
            if (!((OMNamespace)it.next()).getPrefix().equals(prefix)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public void setEncodingStyle(String encodingStyle) throws SOAPException {
        if (((SOAPFactory)((OMElement)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP11Version.getSingleton()) {
            try {
                URI uri = new URI(encodingStyle);
                if (!(this instanceof SOAPEnvelope) && !encodingStyle.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
                    throw new IllegalArgumentException("Invalid Encoding style : " + encodingStyle);
                }
                this.encodingStyle = encodingStyle;
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid Encoding style : " + encodingStyle + ":" + e);
            }
        } else if (((SOAPFactory)((OMElement)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP12Version.getSingleton() && (this instanceof SOAPHeader || this instanceof SOAPBody || this instanceof SOAPFault || this instanceof SOAPFaultElement || this instanceof SOAPEnvelope || this instanceof Detail)) {
            throw new SOAPException("EncodingStyle attribute cannot appear in : " + this);
        }
    }

    public String getAttribute(String name) {
        return ((Element)this.target).getAttribute(name);
    }

    public Attr getAttributeNode(String name) {
        return ((Element)this.target).getAttributeNode(name);
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return ((Element)this.target).getAttributeNodeNS(namespaceURI, localName);
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        return ((Element)this.target).getAttributeNS(namespaceURI, localName);
    }

    public NodeList getElementsByTagName(String name) {
        return this.toSAAJNodeList(((Element)this.target).getElementsByTagName(name));
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.toSAAJNodeList(((Element)this.target).getElementsByTagNameNS(namespaceURI, localName));
    }

    public String getTagName() {
        return ((Element)this.target).getTagName();
    }

    public boolean hasAttribute(String name) {
        return ((Element)this.target).hasAttribute(name);
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return ((Element)this.target).hasAttributeNS(namespaceURI, localName);
    }

    public void removeAttribute(String name) throws DOMException {
        ((Element)this.target).removeAttribute(name);
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        return ((Element)this.target).removeAttributeNode(attr);
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        ((Element)this.target).removeAttributeNS(namespaceURI, localName);
    }

    public void setAttribute(String name, String value) throws DOMException {
        ((Element)this.target).setAttribute(name, value);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        return ((Element)this.target).setAttributeNode(attr);
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        return ((Element)this.target).setAttributeNodeNS(attr);
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        ((Element)this.target).setAttributeNS(namespaceURI, qualifiedName, value);
    }

    public String getValue() {
        if (((OMElement)this.omTarget).getType() == 4) {
            return ((OMElement)this.omTarget).getText();
        }
        if (((OMElement)this.omTarget).getType() == 1) {
            OMNode firstOMChild = ((OMElement)this.omTarget).getFirstOMChild();
            if (firstOMChild instanceof Text) {
                return ((Text)firstOMChild).getData();
            }
            if (firstOMChild instanceof SOAPElementImpl) {
                return ((SOAPElement)firstOMChild).getValue();
            }
        }
        return null;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setValue(String value) {
        OMNode firstChild = ((OMElement)this.omTarget).getFirstOMChild();
        if (firstChild == null) {
            try {
                this.addTextNode(value);
            }
            catch (SOAPException e) {
                throw new RuntimeException("Cannot add text node", e);
            }
        } else if (((Node)firstChild).getNodeType() == 3 && firstChild.getNextOMSibling() == null) {
            ((Text)firstChild).setData(value);
        } else {
            throw new IllegalStateException("This node is not a Text  node and either has more than one child node or has a child node that is not a Text node");
        }
    }

    public String toString() {
        return ((Element)this.target).toString();
    }

    protected void copyContents(SOAPElementImpl childEle, Node child) throws SOAPException {
        Node node;
        NamedNodeMap attributes = child.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr node2 = (Attr)attributes.item(i);
            QName name = node2.getPrefix() == null ? new QName(node2.getNamespaceURI(), node2.getLocalName()) : new QName(node2.getNamespaceURI(), node2.getLocalName(), node2.getPrefix());
            childEle.addAttribute(name, node2.getValue());
        }
        while ((node = child.getFirstChild()) != null) {
            childEle.appendChild(node);
        }
    }
}

