/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.format;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.format.MessageFormatterEx;
import org.apache.axis2.kernel.http.util.URLTemplatingUtil;
import org.apache.axis2.transport.base.BaseConstants;

public class BinaryFormatter
implements MessageFormatterEx {
    private DataHandler getDataHandler(MessageContext messageContext) {
        DataHandler dh;
        OMNode omNode;
        OMElement firstChild = messageContext.getEnvelope().getBody().getFirstElement();
        if (BaseConstants.DEFAULT_BINARY_WRAPPER.equals(firstChild.getQName()) && (omNode = firstChild.getFirstOMChild()) != null && omNode instanceof OMText && (dh = ((OMText)omNode).getDataHandler()) != null && dh instanceof DataHandler) {
            return dh;
        }
        return null;
    }

    public void writeTo(MessageContext messageContext, OMOutputFormat format, OutputStream outputStream, boolean preserve) throws AxisFault {
        DataHandler dh = this.getDataHandler(messageContext);
        if (dh != null) {
            try {
                dh.writeTo(outputStream);
            }
            catch (IOException e) {
                throw new AxisFault("Error serializing binary content of element : " + BaseConstants.DEFAULT_BINARY_WRAPPER, (Throwable)e);
            }
        }
    }

    public String getContentType(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        DataHandler dh = this.getDataHandler(messageContext);
        if (dh != null) {
            return dh.getContentType();
        }
        return null;
    }

    public URL getTargetAddress(MessageContext messageContext, OMOutputFormat format, URL targetURL) throws AxisFault {
        return URLTemplatingUtil.getTemplatedURL((URL)targetURL, (MessageContext)messageContext, (boolean)false);
    }

    public String formatSOAPAction(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        return null;
    }

    @Override
    public DataSource getDataSource(MessageContext messageContext, OMOutputFormat format, String soapAction) throws AxisFault {
        return this.getDataHandler(messageContext).getDataSource();
    }
}

