/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.maven2.server;

import java.io.File;
import java.net.MalformedURLException;
import org.apache.axis2.maven2.server.util.Axis2Server;
import org.apache.axis2.maven2.server.util.RepoHelper;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;

public class SimpleHttpServerMojo
extends AbstractMojo {
    private String repoPath;
    private String confPath;
    private boolean jaxwsService;
    private String stdServiceSrcDir;
    private String jaxwsServiceSrcDir;
    private String moduleSrcDir;
    private String port;
    private boolean fork;
    private int dataBufferSize;
    private PluginDescriptor descriptor;
    private String buildDir;
    private String projectVersion;
    private String projectId;
    private Axis2Server server;

    public RepoHelper getRepoHelper() {
        RepoHelper repoHelper = new RepoHelper(this.repoPath, this.getLog());
        if (this.stdServiceSrcDir != null) {
            repoHelper.setStdServiceSrcDir(this.stdServiceSrcDir);
        }
        if (this.jaxwsServiceSrcDir != null) {
            repoHelper.setJaxwsServiceSrcDir(this.jaxwsServiceSrcDir);
        }
        if (this.moduleSrcDir != null) {
            repoHelper.setModuleSrcDir(this.moduleSrcDir);
        }
        if (this.jaxwsService) {
            repoHelper.setJaxwsService(this.jaxwsService);
            String serviceJarFile = this.buildDir + File.separator + this.projectId + "-" + this.projectVersion + ".jar";
            repoHelper.setServiceJarLocation(serviceJarFile);
        }
        if (this.dataBufferSize > 0) {
            repoHelper.setDataBufferSize(this.dataBufferSize);
        } else {
            repoHelper.setDataBufferSize(2048);
        }
        return repoHelper;
    }

    public void execute() throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)("repo path : " + this.repoPath));
            this.getLog().info((CharSequence)("conf path : " + this.confPath));
            this.getRepoHelper().prepareRepostory();
            this.extendClassLoader();
            String serverPort = this.port == null ? "8080" : this.port;
            this.server = Axis2Server.newInstance(this.repoPath, this.checkFordefaultConfFile(this.confPath), serverPort, this.getLog());
            if (this.fork) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        SimpleHttpServerMojo.this.getLog().info((CharSequence)" Starting Axis2 Simple HTTP Server in a foke mode................. ");
                        SimpleHttpServerMojo.this.server.startServer();
                        SimpleHttpServerMojo.this.getLog().info((CharSequence)" Axis2 Simple HTTP server satreted");
                        SimpleHttpServerMojo.this.waitForShutdown();
                    }
                }).start();
            } else {
                this.server.startServer();
                this.waitForShutdown();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to start AXIS2 HTTP server", e);
        }
    }

    private void extendClassLoader() throws DuplicateRealmException, MalformedURLException {
        ClassRealm realm = this.descriptor.getClassRealm();
        if (realm == null) {
            ClassWorld world = new ClassWorld();
            realm = world.newRealm("maven.plugin." + ((Object)((Object)this)).getClass().getSimpleName(), Thread.currentThread().getContextClassLoader());
        }
        File cls = new File(this.buildDir + File.separator + "classes");
        File testCls = new File(this.buildDir + File.separator + "test-classes");
        realm.addURL(cls.toURI().toURL());
        realm.addURL(testCls.toURI().toURL());
        Thread.currentThread().setContextClassLoader((ClassLoader)realm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForShutdown() {
        final boolean[] shutdown = new boolean[]{false};
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean[] blArray = shutdown;
                synchronized (shutdown) {
                    shutdown[0] = true;
                    shutdown.notify();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
        boolean[] blArray = shutdown;
        synchronized (shutdown) {
            while (!shutdown[0]) {
                try {
                    shutdown.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.server.stopServer();
            this.getLog().info((CharSequence)"Axis2 Simple HTTP server stoped ");
            return;
        }
    }

    private String checkFordefaultConfFile(String inPath) {
        if (inPath != null) {
            return inPath;
        }
        String path = this.repoPath != null ? this.repoPath : "target/work/repository";
        File confFile = new File(path = path + File.separator + "conf" + File.separator + "axis2.xml");
        if (confFile.exists()) {
            return path;
        }
        return null;
    }
}

