/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.maven2.server.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.maven.plugin.logging.Log;

public class RepoHelper {
    private String repoLocation;
    private String serviceJarLocation;
    private String stdServiceDir;
    private String jaxwsServiceDir;
    private String moduleDir;
    private String stdServiceSrcDir;
    private String jaxwsServiceSrcDir;
    private String moduleSrcDir;
    private boolean jaxwsService = false;
    private int dataBufferSize;
    private Log log;

    public int getDataBufferSize() {
        return this.dataBufferSize;
    }

    public void setDataBufferSize(int dataBufferSize) {
        this.dataBufferSize = dataBufferSize;
    }

    public String getModuleSrcDir() {
        return this.moduleSrcDir;
    }

    public void setModuleSrcDir(String moduleSrcDir) {
        this.moduleSrcDir = moduleSrcDir;
    }

    public String getRepoLocation() {
        return this.repoLocation;
    }

    public void setRepoLocation(String repoLocation) {
        this.repoLocation = repoLocation;
    }

    public String getStdServiceSrcDir() {
        return this.stdServiceSrcDir;
    }

    public void setStdServiceSrcDir(String stdServiceSrcDir) {
        this.stdServiceSrcDir = stdServiceSrcDir;
    }

    public String getJaxwsServiceSrcDir() {
        return this.jaxwsServiceSrcDir;
    }

    public void setJaxwsServiceSrcDir(String jaxwsServiceSrcDir) {
        this.jaxwsServiceSrcDir = jaxwsServiceSrcDir;
    }

    public boolean isJaxwsService() {
        return this.jaxwsService;
    }

    public void setJaxwsService(boolean jaxwsService) {
        this.jaxwsService = jaxwsService;
    }

    public String getServiceJarLocation() {
        return this.serviceJarLocation;
    }

    public void setServiceJarLocation(String serviceJarLocation) {
        this.serviceJarLocation = serviceJarLocation;
    }

    public RepoHelper(String repoLocation, Log log) {
        this.repoLocation = repoLocation == null ? "target/work/repository" : repoLocation;
        this.log = log;
        this.initialize();
    }

    public void prepareRepostory() throws IOException {
        this.createDirectoryStructure();
        this.copyResourcesForService();
    }

    private void initialize() {
        this.stdServiceDir = this.repoLocation + File.separator + "services";
        this.jaxwsServiceDir = this.repoLocation + File.separator + "servicejars";
        this.moduleDir = this.repoLocation + File.separator + "modules";
        this.stdServiceSrcDir = "src/main/resources/services";
        this.jaxwsServiceSrcDir = "src/main/resources/serviceJars";
        this.moduleSrcDir = "src/main/resources/modules";
    }

    private void copyResourcesForService() throws IOException {
        if (this.isJaxwsService()) {
            this.copyJaxwsServices();
        } else {
            this.copyStdServices();
        }
        this.copyModules();
        this.copyConfFile();
    }

    private void copyModules() throws IOException {
        if (this.moduleSrcDir == null) {
            return;
        }
        File modsrcFile = new File(this.moduleSrcDir);
        File moddisFile = new File(this.moduleDir);
        if (modsrcFile.exists()) {
            RepoHelper.copyDirectory(modsrcFile, moddisFile, this.getDataBufferSize());
        }
    }

    private void copyJaxwsServices() throws IOException {
        File disFile = new File(this.jaxwsServiceDir + this.serviceJarLocation.substring(this.serviceJarLocation.lastIndexOf(File.separator)));
        File srcFile = this.jaxwsServiceSrcDir != null ? new File(this.serviceJarLocation) : new File(this.jaxwsServiceSrcDir);
        if (srcFile.exists()) {
            RepoHelper.copyDirectory(srcFile, disFile, this.getDataBufferSize());
        }
    }

    private void copyStdServices() throws IOException {
        if (this.stdServiceSrcDir == null) {
            return;
        }
        File srcFile = new File(this.stdServiceSrcDir);
        File disFile = new File(this.stdServiceDir);
        if (srcFile.exists()) {
            RepoHelper.copyDirectory(srcFile, disFile, this.getDataBufferSize());
        }
    }

    private void createDirectoryStructure() {
        File stdServiceFile = new File(this.stdServiceDir);
        File jaxwsServiceFile = new File(this.jaxwsServiceDir);
        File moduleFile = new File(this.moduleDir);
        File confDir = new File(this.repoLocation + File.separator + "conf");
        boolean success = stdServiceFile.mkdirs();
        success = jaxwsServiceFile.mkdirs();
        success = moduleFile.mkdirs();
        success = confDir.mkdir();
        if (success) {
            this.log.info((CharSequence)"Service directories created");
        }
    }

    public static void copyDirectory(File sourceLocation, File targetLocation, int bufferSize) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                RepoHelper.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]), bufferSize);
            }
        } else {
            int len;
            FileInputStream in = new FileInputStream(sourceLocation);
            FileOutputStream out = new FileOutputStream(targetLocation);
            byte[] buf = new byte[bufferSize];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    private void copyConfFile() throws IOException {
        File srcFile = new File("src/main/resources" + File.separator + "axis2.xml");
        File desFile = new File(this.repoLocation + File.separator + "conf" + File.separator + "axis2.xml");
        if (srcFile.exists()) {
            RepoHelper.copyDirectory(srcFile, desFile, this.getDataBufferSize());
        }
    }
}

