/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.data;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.fn.harness.control.ExecutionStateSampler;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.runners.core.metrics.ShortIdMap;
import org.apache.beam.runners.core.metrics.SimpleMonitoringInfoBuilder;
import org.apache.beam.sdk.function.ThrowingRunnable;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PTransformFunctionRegistry {
    private final  @UnknownKeyFor @NonNull @Initialized ExecutionStateSampler. @UnknownKeyFor @NonNull @Initialized ExecutionStateTracker stateTracker;
    private final @UnknownKeyFor @NonNull @Initialized String executionStateUrn;
    private final @UnknownKeyFor @NonNull @Initialized ShortIdMap shortIds;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ThrowingRunnable> runnables = new ArrayList<ThrowingRunnable>();
    private final @UnknownKeyFor @NonNull @Initialized String stateName;

    public PTransformFunctionRegistry(@UnknownKeyFor @NonNull @Initialized ShortIdMap shortIds,  @UnknownKeyFor @NonNull @Initialized ExecutionStateSampler. @UnknownKeyFor @NonNull @Initialized ExecutionStateTracker stateTracker, @UnknownKeyFor @NonNull @Initialized String executionStateUrn) {
        switch (executionStateUrn) {
            case "beam:metric:pardo_execution_time:start_bundle_msecs:v1": {
                this.stateName = "start";
                break;
            }
            case "beam:metric:pardo_execution_time:finish_bundle_msecs:v1": {
                this.stateName = "finish";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown URN %s", executionStateUrn));
            }
        }
        this.shortIds = shortIds;
        this.executionStateUrn = executionStateUrn;
        this.stateTracker = stateTracker;
    }

    public void register(@UnknownKeyFor @NonNull @Initialized String pTransformId, @UnknownKeyFor @NonNull @Initialized String pTransformUniqueName, @UnknownKeyFor @NonNull @Initialized ThrowingRunnable runnable) {
        SimpleMonitoringInfoBuilder miBuilder = new SimpleMonitoringInfoBuilder();
        miBuilder.setUrn(this.executionStateUrn);
        miBuilder.setType("beam:metrics:sum_int64:v1");
        miBuilder.setLabel("PTRANSFORM", pTransformId);
        MetricsApi.MonitoringInfo mi = miBuilder.build();
        if (mi == null) {
            throw new IllegalStateException(String.format("Unable to construct %s counter for PTransform {id=%s, name=%s}", this.executionStateUrn, pTransformId, pTransformUniqueName));
        }
        String shortId = this.shortIds.getOrCreateShortId(mi);
        ExecutionStateSampler.ExecutionState executionState = this.stateTracker.create(shortId, pTransformId, pTransformUniqueName, this.stateName);
        ThrowingRunnable wrapped = () -> {
            executionState.activate();
            try {
                runnable.run();
            }
            finally {
                executionState.deactivate();
            }
        };
        this.runnables.add(wrapped);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ThrowingRunnable> getFunctions() {
        return this.runnables;
    }
}

