/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SpecMonitoringInfoValidator {
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>>> REQUIRED_LABELS = new HashMap<String, Map<String, Set<String>>>();

    public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized String> validate(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized MetricsApi.MonitoringInfo monitoringInfo) {
        if (monitoringInfo.getUrn().isEmpty() || monitoringInfo.getType().isEmpty()) {
            return Optional.of(String.format("MonitoringInfo requires both urn %s and type %s to be specified.", monitoringInfo.getUrn(), monitoringInfo.getType()));
        }
        Map<String, Set<String>> typeToRequiredLabels = REQUIRED_LABELS.get(monitoringInfo.getUrn());
        if (typeToRequiredLabels == null) {
            return Optional.empty();
        }
        Set<String> requiredLabels = typeToRequiredLabels.get(monitoringInfo.getType());
        if (requiredLabels == null) {
            return Optional.empty();
        }
        if (!monitoringInfo.getLabelsMap().keySet().containsAll(requiredLabels)) {
            return Optional.of(String.format("MonitoringInfo with urn: %s should have labels: %s, actual: %s", monitoringInfo.getUrn(), requiredLabels, monitoringInfo.getLabelsMap()));
        }
        return Optional.empty();
    }

    static {
        for (MetricsApi.MonitoringInfoSpecs.Enum enumSpec : MetricsApi.MonitoringInfoSpecs.Enum.values()) {
            if (enumSpec.name().equals("UNRECOGNIZED")) continue;
            MetricsApi.MonitoringInfoSpec spec = (MetricsApi.MonitoringInfoSpec)enumSpec.getValueDescriptor().getOptions().getExtension(MetricsApi.monitoringInfoSpec);
            Map typeToSpec = REQUIRED_LABELS.computeIfAbsent(spec.getUrn(), key -> new HashMap());
            Preconditions.checkState((typeToSpec.put(spec.getType(), new HashSet(spec.getRequiredLabelsList())) == null ? 1 : 0) != 0, (Object)String.format("Found duplicate specs for urn %s and type %s.", spec.getUrn(), spec.getType()));
        }
    }
}

