/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.ddl;

import com.google.common.base.Preconditions;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.model.JsonSchema;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlExecutableStatement;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.ddl.SqlDdlNodes;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;

public class SqlCreateForeignSchema
extends SqlCreate
implements SqlExecutableStatement {
    private final SqlIdentifier name;
    private final SqlNode type;
    private final SqlNode library;
    private final SqlNodeList optionList;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("CREATE FOREIGN SCHEMA", SqlKind.CREATE_FOREIGN_SCHEMA);

    SqlCreateForeignSchema(SqlParserPos pos, boolean replace, boolean ifNotExists, SqlIdentifier name, SqlNode type, SqlNode library, SqlNodeList optionList) {
        super(OPERATOR, pos, replace, ifNotExists);
        this.name = Objects.requireNonNull(name);
        this.type = type;
        this.library = library;
        Preconditions.checkArgument((type == null != (library == null) ? 1 : 0) != 0, (Object)"of type and library, exactly one must be specified");
        this.optionList = optionList;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name, (Object)this.type, (Object)this.library, (Object)this.optionList);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.getReplace()) {
            writer.keyword("CREATE OR REPLACE");
        } else {
            writer.keyword("CREATE");
        }
        writer.keyword("FOREIGN SCHEMA");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.library != null) {
            writer.keyword("LIBRARY");
            this.library.unparse(writer, 0, 0);
        }
        if (this.type != null) {
            writer.keyword("TYPE");
            this.type.unparse(writer, 0, 0);
        }
        if (this.optionList != null) {
            writer.keyword("OPTIONS");
            SqlWriter.Frame frame = writer.startList("(", ")");
            int i = 0;
            for (Pair<SqlIdentifier, SqlNode> c : SqlCreateForeignSchema.options(this.optionList)) {
                if (i++ > 0) {
                    writer.sep(",");
                }
                ((SqlIdentifier)c.left).unparse(writer, 0, 0);
                ((SqlNode)c.right).unparse(writer, 0, 0);
            }
            writer.endList(frame);
        }
    }

    public void execute(CalcitePrepare.Context context) {
        String libraryName;
        Pair<CalciteSchema, String> pair = SqlDdlNodes.schema(context, true, this.name);
        SchemaPlus subSchema0 = ((CalciteSchema)pair.left).plus().getSubSchema((String)pair.right);
        if (subSchema0 != null && !this.getReplace() && !this.ifNotExists) {
            throw SqlUtil.newContextException((SqlParserPos)this.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.schemaExists((String)pair.right));
        }
        if (this.type != null) {
            Preconditions.checkArgument((this.library == null ? 1 : 0) != 0);
            String typeName = (String)((Object)SqlCreateForeignSchema.value(this.type));
            JsonSchema.Type type = (JsonSchema.Type)Util.enumVal(JsonSchema.Type.class, (String)typeName.toUpperCase(Locale.ROOT));
            if (type != null) {
                switch (type) {
                    case JDBC: {
                        libraryName = JdbcSchema.Factory.class.getName();
                        break;
                    }
                    default: {
                        libraryName = null;
                        break;
                    }
                }
            } else {
                libraryName = null;
            }
            if (libraryName == null) {
                throw SqlUtil.newContextException((SqlParserPos)this.type.getParserPosition(), (Resources.ExInst)Static.RESOURCE.schemaInvalidType(typeName, Arrays.toString(JsonSchema.Type.values())));
            }
        } else {
            Preconditions.checkArgument((this.library != null ? 1 : 0) != 0);
            libraryName = (String)((Object)SqlCreateForeignSchema.value(this.library));
        }
        SchemaFactory schemaFactory = (SchemaFactory)AvaticaUtils.instantiatePlugin(SchemaFactory.class, (String)libraryName);
        LinkedHashMap<String, Comparable> operandMap = new LinkedHashMap<String, Comparable>();
        for (Pair<SqlIdentifier, SqlNode> option : SqlCreateForeignSchema.options(this.optionList)) {
            operandMap.put(((SqlIdentifier)option.left).getSimple(), SqlCreateForeignSchema.value((SqlNode)option.right));
        }
        Schema subSchema = schemaFactory.create(((CalciteSchema)pair.left).plus(), (String)pair.right, operandMap);
        ((CalciteSchema)pair.left).add((String)pair.right, subSchema);
    }

    private static Comparable value(SqlNode node) {
        Comparable v = SqlLiteral.value((SqlNode)node);
        return v instanceof NlsString ? ((NlsString)v).getValue() : v;
    }

    private static List<Pair<SqlIdentifier, SqlNode>> options(final SqlNodeList optionList) {
        return new AbstractList<Pair<SqlIdentifier, SqlNode>>(){

            @Override
            public Pair<SqlIdentifier, SqlNode> get(int index) {
                return Pair.of((Object)((SqlIdentifier)optionList.get(index * 2)), (Object)optionList.get(index * 2 + 1));
            }

            @Override
            public int size() {
                return optionList.size() / 2;
            }
        };
    }
}

