package org.apache.camel.component.activemq.converter;

import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.DoubleMap;

@SuppressWarnings("unchecked")
public class ActiveMQMessageConverterLoader implements TypeConverterLoader {


    static abstract class BaseTypeConverter extends TypeConverterSupport {
        private final boolean allowNull;

        public BaseTypeConverter(boolean allowNull) {
            this.allowNull = allowNull;
        }

        @Override
        public boolean allowNull() {
            return allowNull;
        }

        @Override
        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
            try {
                return (T) doConvert(exchange, value);
            } catch (TypeConversionException e) {
                throw e;
            } catch (Exception e) {
                throw new TypeConversionException(value, type, e);
            }
        }
        protected abstract Object doConvert(Exchange exchange, Object value) throws Exception;
    };

    private final DoubleMap<Class<?>, Class<?>, BaseTypeConverter> converters = new DoubleMap<>(2);

    public ActiveMQMessageConverterLoader() {
    }

    private void registerConverters() {
        converters.put(org.apache.activemq.command.ActiveMQMessage.class, org.apache.camel.Exchange.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getActiveMQMessageConverter().toMessage((org.apache.camel.Exchange) value);
            }
        });
        converters.put(org.apache.camel.Processor.class, javax.jms.MessageListener.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getActiveMQMessageConverter().toProcessor((javax.jms.MessageListener) value);
            }
        });
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        registerConverters();
        converters.forEach((k, v, c) -> registry.addTypeConverter(k, v, c));
    }

    private volatile org.apache.camel.component.activemq.converter.ActiveMQMessageConverter activeMQMessageConverter;
    private org.apache.camel.component.activemq.converter.ActiveMQMessageConverter getActiveMQMessageConverter() {
        if (activeMQMessageConverter == null) {
            synchronized (this) {
                if (activeMQMessageConverter == null) {
                    activeMQMessageConverter = new org.apache.camel.component.activemq.converter.ActiveMQMessageConverter();
                }
            }
        }
        return activeMQMessageConverter;
    }
}
