/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ses;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.ses.Ses2Configuration;
import org.apache.camel.component.aws2.ses.Ses2Endpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.ses.model.Body;
import software.amazon.awssdk.services.ses.model.Content;
import software.amazon.awssdk.services.ses.model.Destination;
import software.amazon.awssdk.services.ses.model.Message;
import software.amazon.awssdk.services.ses.model.RawMessage;
import software.amazon.awssdk.services.ses.model.SendEmailRequest;
import software.amazon.awssdk.services.ses.model.SendEmailResponse;
import software.amazon.awssdk.services.ses.model.SendRawEmailRequest;
import software.amazon.awssdk.services.ses.model.SendRawEmailResponse;

public class Ses2Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(Ses2Producer.class);
    private transient String sesProducerToString;

    public Ses2Producer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        if (!(exchange.getIn().getBody() instanceof javax.mail.Message)) {
            SendEmailRequest request = this.createMailRequest(exchange);
            LOG.trace("Sending request [{}] from exchange [{}]...", (Object)request, (Object)exchange);
            SendEmailResponse result = this.getEndpoint().getSESClient().sendEmail(request);
            LOG.trace("Received result [{}]", (Object)result);
            Message message = Ses2Producer.getMessageForResponse(exchange);
            message.setHeader("CamelAwsSesMessageId", (Object)result.messageId());
        } else {
            SendRawEmailRequest request = this.createRawMailRequest(exchange);
            LOG.trace("Sending request [{}] from exchange [{}]...", (Object)request, (Object)exchange);
            SendRawEmailResponse result = this.getEndpoint().getSESClient().sendRawEmail(request);
            LOG.trace("Received result [{}]", (Object)result);
            Message message = Ses2Producer.getMessageForResponse(exchange);
            message.setHeader("CamelAwsSesMessageId", (Object)result.messageId());
        }
    }

    private SendEmailRequest createMailRequest(Exchange exchange) {
        SendEmailRequest.Builder request = SendEmailRequest.builder();
        request.source(this.determineFrom(exchange));
        request.destination(this.determineTo(exchange));
        request.returnPath(this.determineReturnPath(exchange));
        request.replyToAddresses(this.determineReplyToAddresses(exchange));
        request.message(this.createMessage(exchange));
        return (SendEmailRequest)request.build();
    }

    private SendRawEmailRequest createRawMailRequest(Exchange exchange) throws Exception {
        SendRawEmailRequest.Builder request = SendRawEmailRequest.builder();
        request.source(this.determineFrom(exchange));
        request.destinations(this.determineRawTo(exchange));
        request.rawMessage(this.createRawMessage(exchange));
        return (SendRawEmailRequest)request.build();
    }

    private software.amazon.awssdk.services.ses.model.Message createMessage(Exchange exchange) {
        Message.Builder message = software.amazon.awssdk.services.ses.model.Message.builder();
        Boolean isHtmlEmail = (Boolean)exchange.getIn().getHeader("CamelAwsSesHtmlEmail", (Object)false, Boolean.class);
        String content = (String)exchange.getIn().getBody(String.class);
        if (isHtmlEmail.booleanValue()) {
            message.body((Body)Body.builder().html((Content)Content.builder().data(content).build()).build());
        } else {
            message.body((Body)Body.builder().text((Content)Content.builder().data(content).build()).build());
        }
        message.subject((Content)Content.builder().data(this.determineSubject(exchange)).build());
        return (software.amazon.awssdk.services.ses.model.Message)message.build();
    }

    private RawMessage createRawMessage(Exchange exchange) throws Exception {
        RawMessage.Builder message = RawMessage.builder();
        javax.mail.Message content = (javax.mail.Message)exchange.getIn().getBody(javax.mail.Message.class);
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        try {
            content.writeTo((OutputStream)byteOutput);
        }
        catch (Exception e) {
            LOG.error("Cannot write to byte Array");
            throw e;
        }
        byte[] messageByteArray = byteOutput.toByteArray();
        message.data(SdkBytes.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(messageByteArray)));
        return (RawMessage)message.build();
    }

    private Collection<String> determineReplyToAddresses(Exchange exchange) {
        List<String> replyToAddresses = (List<String>)exchange.getIn().getHeader("CamelAwsSesReplyToAddresses", List.class);
        if (replyToAddresses == null) {
            replyToAddresses = this.getConfiguration().getReplyToAddresses();
        }
        return replyToAddresses;
    }

    private String determineReturnPath(Exchange exchange) {
        String returnPath = (String)exchange.getIn().getHeader("CamelAwsSesReturnPath", String.class);
        if (returnPath == null) {
            returnPath = this.getConfiguration().getReturnPath();
        }
        return returnPath;
    }

    private Destination determineTo(Exchange exchange) {
        List<String> to = (List<String>)exchange.getIn().getHeader("CamelAwsSesTo", List.class);
        if (to == null) {
            to = this.getConfiguration().getTo();
        }
        return (Destination)Destination.builder().toAddresses((Collection)to).build();
    }

    private List<String> determineRawTo(Exchange exchange) {
        List<String> to = (List<String>)exchange.getIn().getHeader("CamelAwsSesTo", List.class);
        if (to == null) {
            to = this.getConfiguration().getTo();
        }
        return to;
    }

    private String determineFrom(Exchange exchange) {
        String from = (String)exchange.getIn().getHeader("CamelAwsSesFrom", String.class);
        if (from == null) {
            from = this.getConfiguration().getFrom();
        }
        return from;
    }

    private String determineSubject(Exchange exchange) {
        String subject = (String)exchange.getIn().getHeader("CamelAwsSesSubject", String.class);
        if (subject == null) {
            subject = this.getConfiguration().getSubject();
        }
        return subject;
    }

    protected Ses2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.sesProducerToString == null) {
            this.sesProducerToString = "SesProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.sesProducerToString;
    }

    public Ses2Endpoint getEndpoint() {
        return (Ses2Endpoint)super.getEndpoint();
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

