/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.NamedRoute;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.Tracer;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.support.processor.DefaultExchangeFormatter;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTracer
extends ServiceSupport
implements CamelContextAware,
Tracer {
    private static final String TRACING_OUTPUT = "%-4.4s [%-12.12s] [%-33.33s]";
    private static final Logger LOG = LoggerFactory.getLogger((String)"org.apache.camel.Tracing");
    private String tracingFormat = "%-4.4s [%-12.12s] [%-33.33s]";
    private CamelContext camelContext;
    private boolean enabled = true;
    private boolean standby;
    private boolean traceRests;
    private boolean traceTemplates;
    private long traceCounter;
    private ExchangeFormatter exchangeFormatter;
    private String tracePattern;
    private transient String[] patterns;
    private boolean traceBeforeAndAfterRoute = true;

    public DefaultTracer() {
        DefaultExchangeFormatter formatter = new DefaultExchangeFormatter();
        formatter.setShowExchangeId(true);
        formatter.setShowExchangePattern(false);
        formatter.setMultiline(false);
        formatter.setShowHeaders(true);
        formatter.setStyle(DefaultExchangeFormatter.OutputStyle.Default);
        this.setExchangeFormatter((ExchangeFormatter)formatter);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void traceBeforeNode(NamedNode node, Exchange exchange) {
        if (this.shouldTrace(node)) {
            ++this.traceCounter;
            String routeId = (String)ExpressionBuilder.routeIdExpression().evaluate(exchange, String.class);
            String label = URISupport.sanitizeUri((String)StringHelper.limitLength((String)node.getLabel(), (int)50));
            StringBuilder sb = new StringBuilder(512);
            sb.append(String.format(this.tracingFormat, "   ", routeId, label));
            sb.append(" ");
            String data = this.exchangeFormatter.format(exchange);
            sb.append(data);
            String out = sb.toString();
            this.dumpTrace(out, node);
        }
    }

    public void traceAfterNode(NamedNode node, Exchange exchange) {
    }

    public void traceSentNode(NamedNode node, Exchange exchange, Endpoint endpoint, long elapsed) {
        if (!this.traceBeforeAndAfterRoute) {
            return;
        }
        if (!endpoint.isRemote()) {
            return;
        }
        if (this.shouldTrace(node)) {
            boolean failed;
            EndpointServiceLocation esl;
            String routeId = (String)ExpressionBuilder.routeIdExpression().evaluate(exchange, String.class);
            StringBuilder sb = new StringBuilder(128);
            sb.append(String.format(this.tracingFormat, "   ", routeId, ""));
            sb.append(" ");
            StringJoiner sj = new StringJoiner(", ");
            sj.add("url=" + String.valueOf(endpoint));
            if (endpoint instanceof EndpointServiceLocation && (esl = (EndpointServiceLocation)endpoint).getServiceUrl() != null) {
                Map map;
                sj.add("service=" + esl.getServiceUrl());
                String protocol = esl.getServiceProtocol();
                if (protocol != null) {
                    sj.add("protocol=" + protocol);
                }
                if ((map = esl.getServiceMetadata()) != null) {
                    map.forEach((k, v) -> sj.add(k + "=" + v));
                }
            }
            String data = "Sent " + ((failed = exchange.isFailed()) ? "failed" : "success") + " took " + TimeUtils.printDuration((long)elapsed, (boolean)true);
            data = data + " (" + String.valueOf(sj) + ")";
            sb.append(data);
            String out = sb.toString();
            this.dumpTrace(out, node);
        }
    }

    public void traceBeforeRoute(NamedRoute route, Exchange exchange) {
        EndpointServiceLocation esl;
        Endpoint endpoint;
        if (!this.traceBeforeAndAfterRoute) {
            return;
        }
        String uri = route.getEndpointUrl();
        String label = "from[" + URISupport.sanitizeUri((String)(StringHelper.limitLength((String)uri, (int)50) + "]"));
        boolean original = route.getRouteId().equals(exchange.getFromRouteId());
        String arrow = original ? "*-->" : "--->";
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(this.tracingFormat, arrow, route.getRouteId(), label));
        sb.append(" ");
        Object data = this.exchangeFormatter.format(exchange);
        String out = String.valueOf(sb) + (String)data;
        this.dumpTrace(out, route);
        if (original && (endpoint = exchange.getFromEndpoint()) instanceof EndpointServiceLocation && (esl = (EndpointServiceLocation)endpoint).getServiceUrl() != null) {
            Map map;
            StringJoiner sj = new StringJoiner(", ");
            sj.add("url=" + String.valueOf(endpoint));
            sj.add("service=" + esl.getServiceUrl());
            String protocol = esl.getServiceProtocol();
            if (protocol != null) {
                sj.add("protocol=" + protocol);
            }
            if ((map = esl.getServiceMetadata()) != null) {
                map.forEach((k, v) -> sj.add(k + "=" + v));
            }
            data = "Received (" + String.valueOf(sj) + ")";
            sb = new StringBuilder();
            sb.append(String.format(this.tracingFormat, "", route.getRouteId(), ""));
            sb.append(" ");
            out = String.valueOf(sb) + (String)data;
            this.dumpTrace(out, route);
        }
    }

    public void traceAfterRoute(NamedRoute route, Exchange exchange) {
        if (!this.traceBeforeAndAfterRoute) {
            return;
        }
        String uri = route.getEndpointUrl();
        String label = "from[" + URISupport.sanitizeUri((String)(StringHelper.limitLength((String)uri, (int)50) + "]"));
        boolean original = route.getRouteId().equals(exchange.getFromRouteId());
        String arrow = original ? "*<--" : "<---";
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(this.tracingFormat, arrow, route.getRouteId(), label));
        sb.append(" ");
        String data = this.exchangeFormatter.format(exchange);
        sb.append(data);
        String out = sb.toString();
        this.dumpTrace(out, route);
    }

    public boolean shouldTrace(NamedNode definition) {
        if (!this.enabled) {
            return false;
        }
        boolean pattern = true;
        if (this.patterns != null) {
            pattern = this.shouldTracePattern(definition);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Should trace evaluated {} -> pattern: {}", (Object)definition.getId(), (Object)pattern);
        }
        return pattern;
    }

    public long getTraceCounter() {
        return this.traceCounter;
    }

    public void resetTraceCounter() {
        this.traceCounter = 0L;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isStandby() {
        return this.standby;
    }

    public void setStandby(boolean standby) {
        this.standby = standby;
    }

    public boolean isTraceRests() {
        return this.traceRests;
    }

    public void setTraceRests(boolean traceRests) {
        this.traceRests = traceRests;
    }

    public boolean isTraceTemplates() {
        return this.traceTemplates;
    }

    public void setTraceTemplates(boolean traceTemplates) {
        this.traceTemplates = traceTemplates;
    }

    public String getTracePattern() {
        return this.tracePattern;
    }

    public void setTracePattern(String tracePattern) {
        this.tracePattern = tracePattern;
        this.patterns = tracePattern != null ? tracePattern.split(",") : null;
    }

    public boolean isTraceBeforeAndAfterRoute() {
        return this.traceBeforeAndAfterRoute;
    }

    public void setTraceBeforeAndAfterRoute(boolean traceBeforeAndAfterRoute) {
        this.traceBeforeAndAfterRoute = traceBeforeAndAfterRoute;
    }

    public ExchangeFormatter getExchangeFormatter() {
        return this.exchangeFormatter;
    }

    public void setExchangeFormatter(ExchangeFormatter exchangeFormatter) {
        this.exchangeFormatter = exchangeFormatter;
    }

    protected void dumpTrace(String out, Object node) {
        String name = LoggerHelper.getLineNumberLoggerName((Object)node);
        if (name != null) {
            Logger log = LoggerFactory.getLogger((String)name);
            log.info(out);
        } else {
            LOG.info(out);
        }
    }

    protected boolean shouldTracePattern(NamedNode definition) {
        for (String pattern : this.patterns) {
            String id = definition.getId();
            if (PatternHelper.matchPattern((String)id, (String)pattern)) {
                return true;
            }
            String routeId = CamelContextHelper.getRouteId((NamedNode)definition);
            if (routeId == null || Objects.equals(routeId, id) || !PatternHelper.matchPattern((String)routeId, (String)pattern)) continue;
            return true;
        }
        return false;
    }

    protected void doStart() throws Exception {
        if (this.getCamelContext().getTracingLoggingFormat() != null) {
            this.tracingFormat = this.getCamelContext().getTracingLoggingFormat();
        }
    }
}

